/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeUtility {
    protected static Logger logger = LoggerFactory.getLogger(AttributeUtility.class);

    public static void checkRegex(String regex, String text) {
        try {
            Matcher matcher;
            if (regex == null) {
                return;
            }
            Pattern pattern = Pattern.compile(regex);
            if (text != null && !(matcher = pattern.matcher(text)).find()) {
                throw new RuntimeException("The value '" + text + "' does not match the requested regular expression '" + regex + "'.");
            }
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("'" + regex + "' is not a valid regular expression", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String evaluateNullForDefaultValue(String defaultValueAsString) {
        if (defaultValueAsString == null || defaultValueAsString.compareTo("null") == 0) {
            return null;
        }
        return defaultValueAsString;
    }

    public static Object evaluateValueStringAccordingBaseType(PropertyTypeName.BaseType baseType, String valueAsString) {
        if (valueAsString == null || valueAsString.compareTo("null") == 0) {
            return null;
        }
        if (valueAsString != null) {
            switch (baseType) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(valueAsString);
                }
                case INTEGER: {
                    return Integer.parseInt(valueAsString);
                }
                case SHORT: {
                    return Short.parseShort(valueAsString);
                }
                case LONG: {
                    return Long.parseLong(valueAsString);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(valueAsString));
                }
                case DOUBLE: {
                    return Double.parseDouble(valueAsString);
                }
                case DATE: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
                    try {
                        return sdf.parse(valueAsString);
                    }
                    catch (ParseException e) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Error while parsing annotated default ");
                        stringBuffer.append(Date.class.getSimpleName());
                        stringBuffer.append(". The provided default value is '");
                        stringBuffer.append(valueAsString);
                        stringBuffer.append("' which does not match the pattern '");
                        stringBuffer.append("yyyy-MM-dd HH:mm:ss.SSS Z");
                        stringBuffer.append("'.");
                        throw new RuntimeException(stringBuffer.toString(), e);
                    }
                }
                case STRING: {
                    return valueAsString;
                }
                case BINARY: {
                    return valueAsString.getBytes();
                }
                case BYTE: {
                    return Byte.parseByte(valueAsString);
                }
                case PROPERTY: {
                    return null;
                }
            }
        }
        return null;
    }

    public static LocalDateTime checkDateTimeString(String dateTimeString) throws DateTimeParseException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS Z");
        return LocalDateTime.parse(dateTimeString, formatter);
    }
}

