/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.core.JsonGenerationException;
import org.gcube.com.fasterxml.jackson.core.JsonParseException;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonMappingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.Module;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.SerializationFeature;
import org.gcube.com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import org.gcube.com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import org.gcube.com.fasterxml.jackson.databind.module.SimpleModule;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.discovery.Discovery;
import org.gcube.informationsystem.discovery.knowledge.Knowledge;
import org.gcube.informationsystem.model.reference.ModelElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.serialization.ElementMappingAction;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementMapper {
    private static Logger logger;
    private static boolean initialized;
    protected static final ObjectMapper mapper;
    protected static final Map<String, Class<? extends Element>> knownTypes;
    protected static final Map<Class<? extends Element>, Class<? extends Element>> interfaceToImplementation;

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <El extends Element, ELImpl extends El> void addDynamicAssociation(Class<El> interfaceClz, Class<ELImpl> implementationClass) {
        interfaceToImplementation.put(interfaceClz, implementationClass);
    }

    protected static <El extends Element, ELImpl extends El> void registerSubtypes(Class<El> interfaceClz, Class<ELImpl> implementationClass) {
        String typeName = TypeMapper.getType(interfaceClz);
        SimpleModule module = new SimpleModule(typeName);
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
        resolver.addMapping(interfaceClz, implementationClass);
        module.setAbstractTypes(resolver);
        mapper.registerModule((Module)module);
        mapper.registerSubtypes(new Class[]{interfaceClz});
    }

    public static <El extends Element> void registerSubtype(Class<El> clz) {
        String typeName = TypeMapper.getType(clz);
        knownTypes.put(typeName, clz);
        mapper.registerSubtypes(new Class[]{clz});
    }

    public static <T extends OutputStream, El extends Element> T marshal(El object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, El extends Element> T marshal(El object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <El extends Element> String marshal(El object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <El extends Element> String marshal(List<El> list) throws JsonProcessingException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, Element.class);
        return mapper.writerFor((JavaType)type).writeValueAsString(list);
    }

    public static <El extends Element> String marshal(El[] array) throws JsonProcessingException {
        return mapper.writeValueAsString(array);
    }

    protected static StringBuffer getError(String unknownType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(unknownType);
        stringBuffer.append(" is an unknown type. Please provide ");
        stringBuffer.append("supertypes");
        stringBuffer.append(" property as string array to allow to instantiate the most appropriated class.");
        return stringBuffer;
    }

    protected static ObjectNode setTypeToBestAvailable(ObjectNode objectNode) {
        String unknownType = objectNode.get("type").asText();
        ArrayNode arrayNode = (ArrayNode)objectNode.get("supertypes");
        String candidatedSupertype = null;
        if (arrayNode != null) {
            for (int i = 0; i < arrayNode.size(); ++i) {
                String superType = arrayNode.get(i).asText();
                if (!knownTypes.containsKey(superType)) continue;
                candidatedSupertype = superType;
                try {
                    AccessType accessType = AccessType.getAccessType(superType);
                    if (accessType.getDummyImplementationClass() == null) break;
                    candidatedSupertype = accessType.getDummyImplementationClass().getSimpleName();
                }
                catch (Exception exception) {}
                break;
            }
        }
        if (candidatedSupertype != null) {
            if (!objectNode.has("expectedtype")) {
                objectNode.set("expectedtype", objectNode.get("type"));
            }
            objectNode.set("type", (JsonNode)new TextNode(candidatedSupertype));
            objectNode.remove("supertypes");
            return objectNode;
        }
        StringBuffer stringBuffer = ElementMapper.getError(unknownType);
        logger.trace("Unable to unmarshall {}. {}", (Object)objectNode.toString(), (Object)stringBuffer.toString());
        throw new RuntimeException(stringBuffer.toString());
    }

    protected static JsonNode analizeTypes(ObjectNode objectNode) {
        String cls = null;
        JsonNode typeJN = objectNode.get("type");
        if (typeJN != null) {
            cls = objectNode.get("type").asText();
        }
        if (cls == null && objectNode.getNodeType() == JsonNodeType.OBJECT) {
            cls = "Property";
        }
        if (!knownTypes.containsKey(cls)) {
            objectNode = ElementMapper.setTypeToBestAvailable(objectNode);
        }
        Iterator iterator = objectNode.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            JsonNode jn = objectNode.get(fieldName);
            switch (jn.getNodeType()) {
                case OBJECT: {
                    jn = ElementMapper.analizeTypes((ObjectNode)jn);
                    break;
                }
                case ARRAY: {
                    jn = ElementMapper.analizeTypes((ArrayNode)jn);
                    break;
                }
            }
            objectNode.replace(fieldName, jn);
        }
        return objectNode;
    }

    protected static ArrayNode analizeTypes(ArrayNode arrayNode) {
        ArrayNode ret = mapper.createArrayNode();
        for (JsonNode jsonNode : arrayNode) {
            switch (jsonNode.getNodeType()) {
                case OBJECT: {
                    jsonNode = ElementMapper.analizeTypes((ObjectNode)jsonNode);
                    break;
                }
                case ARRAY: {
                    jsonNode = ElementMapper.analizeTypes((ArrayNode)jsonNode);
                    break;
                }
            }
            ret.add(jsonNode);
        }
        return ret;
    }

    public static <El extends Element> El unmarshal(Class<El> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (El)((Element)mapper.readValue(reader, clz));
        }
        catch (InvalidTypeIdException e) {
            if (!ModelElement.class.isAssignableFrom(clz)) {
                throw e;
            }
            JsonNode jsonNode = mapper.readTree(reader);
            jsonNode = ElementMapper.analizeTypes((ObjectNode)jsonNode);
            try {
                return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
            }
            catch (Throwable t) {
                throw e;
            }
        }
    }

    public static <El extends Element> El unmarshal(Class<El> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (El)((Element)mapper.readValue(stream, clz));
        }
        catch (InvalidTypeIdException e) {
            if (!ModelElement.class.isAssignableFrom(clz)) {
                throw e;
            }
            JsonNode jsonNode = mapper.readTree(stream);
            jsonNode = ElementMapper.analizeTypes((ObjectNode)jsonNode);
            try {
                return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
            }
            catch (Throwable t) {
                throw e;
            }
        }
    }

    public static <El extends Element> El unmarshal(Class<El> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (El)((Element)mapper.readValue(string, clz));
        }
        catch (InvalidTypeIdException e) {
            if (!ModelElement.class.isAssignableFrom(clz)) {
                throw e;
            }
            JsonNode jsonNode = mapper.readTree(string);
            jsonNode = ElementMapper.analizeTypes((ObjectNode)jsonNode);
            try {
                return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
            }
            catch (Throwable t) {
                throw e;
            }
        }
    }

    public static <El extends Element> List<El> unmarshalList(Class<El> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        try {
            return (List)mapper.readValue(string, (JavaType)type);
        }
        catch (InvalidTypeIdException e) {
            if (!ModelElement.class.isAssignableFrom(clz)) {
                throw e;
            }
            ArrayList<El> ret = new ArrayList<El>();
            ArrayNode arrayNode = (ArrayNode)mapper.readTree(string);
            try {
                for (JsonNode jsonNode : arrayNode) {
                    jsonNode = ElementMapper.analizeTypes((ObjectNode)jsonNode);
                    ret.add(ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode)));
                }
            }
            catch (Throwable t) {
                throw e;
            }
            return ret;
        }
    }

    public static <El extends Element> List<El> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Element.class);
        try {
            return (List)mapper.readValue(string, (JavaType)type);
        }
        catch (InvalidTypeIdException e) {
            ArrayList<Element> ret = new ArrayList<Element>();
            ArrayNode arrayNode = (ArrayNode)mapper.readTree(string);
            try {
                for (JsonNode jsonNode : arrayNode) {
                    jsonNode = ElementMapper.analizeTypes((ObjectNode)jsonNode);
                    ret.add(ElementMapper.unmarshal(Element.class, mapper.writeValueAsString((Object)jsonNode)));
                }
            }
            catch (Throwable t) {
                throw e;
            }
            return ret;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var6_9;
        AccessType[] accessTypes;
        logger = LoggerFactory.getLogger(ElementMapper.class);
        initialized = false;
        logger.debug("Initializing {} in ClassLoader {}", (Object)ElementMapper.class.getSimpleName(), (Object)Thread.currentThread().getContextClassLoader());
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.getSerializationConfig().with(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        mapper.setDateFormat((DateFormat)sdf);
        knownTypes = new HashMap<String, Class<? extends Element>>();
        interfaceToImplementation = new HashMap<Class<? extends Element>, Class<? extends Element>>();
        HashSet<Package> packages = new HashSet<Package>();
        Class<Type> tdClz = Type.class;
        ElementMapper.registerSubtype(tdClz);
        packages.add(tdClz.getPackage());
        AccessType[] accessTypeArray = accessTypes = AccessType.values();
        int n = accessTypeArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            AccessType accessType = accessTypeArray[var6_9];
            Class clz = accessType.getTypeClass();
            if (!Type.class.isAssignableFrom(clz)) {
                Class dynamicImplementationClz = TypeMapper.getDynamicImplementation(clz);
                if (dynamicImplementationClz != null) {
                    ElementMapper.addDynamicAssociation(clz, dynamicImplementationClz);
                } else {
                    Class dummyClz = accessType.getDummyImplementationClass();
                    if (dummyClz != null) {
                        ElementMapper.registerSubtype(dummyClz);
                    } else {
                        ElementMapper.registerSubtype(clz);
                    }
                    packages.add(clz.getPackage());
                }
            }
            ++var6_9;
        }
        LinkedHashSet<AccessType> baseTypes = new LinkedHashSet<AccessType>();
        baseTypes.add(AccessType.PROPERTY_ELEMENT);
        baseTypes.add(AccessType.ENTITY_ELEMENT);
        baseTypes.add(AccessType.RELATION_ELEMENT);
        for (AccessType accessType : baseTypes) {
            Class clz = accessType.getTypeClass();
            try {
                Discovery discovery = new Discovery(clz);
                switch (accessType) {
                    case PROPERTY_ELEMENT: {
                        discovery.addStopClass(Property.class);
                        break;
                    }
                    case ENTITY_ELEMENT: {
                        discovery.addStopClass(Resource.class);
                        discovery.addStopClass(Facet.class);
                        break;
                    }
                    case RELATION_ELEMENT: {
                        discovery.addStopClass(IsRelatedTo.class);
                        discovery.addStopClass(ConsistsOf.class);
                        break;
                    }
                }
                discovery.addPackages(packages);
                discovery.addDiscoveredElementActions(new ElementMappingAction());
                discovery.discover();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Knowledge.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Class clazz : interfaceToImplementation.keySet()) {
            Class<? extends Element> implClz = interfaceToImplementation.get(clazz);
            ElementMapper.registerSubtypes(clazz, implClz);
        }
    }
}

