/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.persistence;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.gcube.smartgears.configuration.ComponentConfiguration;
import org.gcube.smartgears.configuration.ConfiguredWith;
import org.gcube.smartgears.persistence.LocalWriterConfiguration;
import org.gcube.smartgears.persistence.PersistenceWriter;
import org.gcube.smartgears.utils.Utils;

@ConfiguredWith(value=LocalWriterConfiguration.class)
public class LocalWriter
implements PersistenceWriter {
    private String location;

    @Override
    public void configure(ComponentConfiguration configuration) {
        this.location = ((LocalWriterConfiguration)configuration).getLocation();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public File writefile(String path) {
        Utils.notNull("relative path", path);
        return Utils.fileAt(new File(this.location, path).getAbsolutePath()).toWrite();
    }

    @Override
    public File file(String path) {
        Utils.notNull("relative path", path);
        return Utils.fileAt(new File(this.location, path).getAbsolutePath()).toRead();
    }

    public void validate() {
        File locationDir = new File(this.location);
        if (!(locationDir.exists() && locationDir.isDirectory() && locationDir.canRead() && locationDir.canWrite())) {
            throw new IllegalStateException("invalid node configuration: home " + this.location + " does not exist or is not a directory or cannot be accessed in read/write mode");
        }
    }

    @Override
    public long getFreeSpace() {
        try {
            return Files.getFileStore(Paths.get(this.location, new String[0])).getUsableSpace();
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

