/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.documentstore.configuration.LibraryConfigurationBinder;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FallbackMonitor.class);
    private static final String ELABORATION_FILE_SUFFIX = ".ELABORATION";
    private static final String ELABORATION_FILE_NOT_DELETED_SUFFIX = ".ELABORATION.NOT-DELETED";
    protected final PersistenceBackend persistenceBackend;
    protected final String initialValidContext;
    public static final int INITIAL_DELAY = 1;
    public static final int DELAY = 10;
    public static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;

    public FallbackMonitor(PersistenceBackend persistenceBackend) {
        this(persistenceBackend, true);
    }

    public FallbackMonitor(PersistenceBackend persistenceBackend, boolean schedule) {
        this.persistenceBackend = persistenceBackend;
        try {
            Secret secret = SecretManagerProvider.get();
            this.initialValidContext = secret.getContext();
        }
        catch (Throwable t) {
            String error = "It was not possible to obtain the initial context in " + FallbackMonitor.class.getSimpleName();
            logger.error(error, t);
            throw new RuntimeException(error, t);
        }
        if (schedule) {
            ExecutorUtils.FALLBACK_ELABORATOR_POOL.scheduleAtFixedRate(this, 1L, 10L, TimeUnit.MINUTES);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void elaborateFile(File elaborationFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(elaborationFile));){
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    Object record = RecordUtility.getRecord(line);
                    this.persistenceBackend.accountWithFallback(new Record[]{record});
                }
                catch (Throwable e) {
                    logger.error("Was not possible parse line {} to obtain a valid Record. Going to writing back this line as string fallback file.", (Object)line, (Object)e);
                    FallbackPersistenceBackend fallbackPersistenceBackend = this.persistenceBackend.getFallbackPersistence();
                    try {
                        fallbackPersistenceBackend.printLine(line);
                    }
                    catch (Throwable e1) {
                        logger.error("Line {} will be lost", (Object)line, (Object)e1);
                    }
                }
            }
            return;
        }
        catch (Throwable e) {
            logger.error("Error elaborating {}", (Object)elaborationFile.getAbsoluteFile(), (Object)e);
        }
    }

    @Deprecated
    protected void manageOldAccountingFile() {
        FallbackPersistenceBackend fallbackPersistenceBackend = this.persistenceBackend.getFallbackPersistence();
        this.elaborateFallbackFile(fallbackPersistenceBackend.getOldFallbackFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void elaborateFallbackFile(File elaborationFile) {
        if (elaborationFile != null && elaborationFile.exists()) {
            try {
                this.elaborateFile(elaborationFile);
            }
            finally {
                if (elaborationFile.exists()) {
                    boolean deleted = elaborationFile.delete();
                    if (!deleted) {
                        logger.error("Failed to delete file {}", (Object)elaborationFile.getAbsolutePath());
                        File elaborationFileNotDeleted = new File(elaborationFile.getAbsolutePath() + ELABORATION_FILE_NOT_DELETED_SUFFIX);
                        elaborationFile.renameTo(elaborationFileNotDeleted);
                    }
                } else {
                    logger.error("File {} does not exists. This is really starge and should not occur. Please contact the administrator.", (Object)elaborationFile.getAbsolutePath());
                }
            }
        }
    }

    protected void elaborateFallbackFile() {
        FallbackPersistenceBackend fallbackPersistenceBackend = this.persistenceBackend.getFallbackPersistence();
        File file = fallbackPersistenceBackend.getFallbackFile();
        logger.trace("Trying to persist {}s which were persisted using fallback on file {}", (Object)Record.class.getSimpleName(), (Object)file.getAbsoluteFile());
        Long timestamp = Calendar.getInstance().getTimeInMillis();
        File elaborationFile = fallbackPersistenceBackend.moveFallbackFile(".ELABORATION." + timestamp.toString());
        this.elaborateFallbackFile(elaborationFile);
    }

    @Override
    public void run() {
        try {
            logger.info("Trying to persist {}s which were persisted using fallback using generated credential", (Object)Record.class.getSimpleName());
            LibraryConfigurationBinder configurationBinder = LibraryConfigurationBinder.getInstance();
            AuthorizationProvider authorizationProvider = configurationBinder.getAuthorizationProvider();
            String currentContext = SecretManagerProvider.get().getContext();
            AuthorizedTasks.executeSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    FallbackMonitor.this.elaborateFallbackFile();
                    FallbackMonitor.this.manageOldAccountingFile();
                }
            }, (Secret)authorizationProvider.getSecretForContext(currentContext));
        }
        catch (Throwable t) {
            logger.info("The attemp to persist {}s failed records using generated credential (Reason {}). Trying with initial credential", (Object)Record.class.getSimpleName(), (Object)t.getMessage());
            this.elaborateFallbackFile();
            this.manageOldAccountingFile();
        }
    }
}

