/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.handlers.container.ContainerPipeline;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager {
    private static Logger log = LoggerFactory.getLogger(ContainerManager.class);
    public static ContainerManager instance = new ContainerManager();
    private ContainerContext context;
    private ContainerPipeline pipeline;

    private ContainerManager() {
    }

    public ContainerContext start(ContainerContext context) {
        this.context = context;
        try {
            if (context.configuration().mode() != Mode.offline) {
                this.validateContainer(context);
            }
            this.saveContainerState();
            List<ContainerHandler> handlers = ProviderFactory.provider().containerHandlers();
            log.trace("managing container lifecycle with {}", handlers);
            this.startHandlers(handlers);
            context.lifecycle().moveTo(ContainerState.active);
            return context;
        }
        catch (RuntimeException e) {
            log.error("cannot manage container (see cause)", (Throwable)e);
            if (context != null) {
                context.lifecycle().moveTo(ContainerState.failed);
            }
            throw e;
        }
    }

    private void saveContainerState() {
        File file = this.context.persistenceWriter().file("ghn.xml");
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(this.context.id());
        }
        catch (Exception e) {
            log.error("error serializing cointainer state");
            throw new RuntimeException(e);
        }
    }

    private void validateContainer(ContainerContext context) {
        Set foundContexts;
        context.configuration().validate();
        try {
            foundContexts = context.authorizationProvider().getContexts();
        }
        catch (Exception e) {
            log.error("error authorizing container", (Throwable)e);
            throw new RuntimeException("error authorizing container, moving the container to failed", e);
        }
        if (foundContexts.isEmpty()) {
            log.error("no valid contexts found, moving the container to failed");
            throw new RuntimeException("no valid contexts found, moving the container to failed");
        }
    }

    public void manage(ApplicationContext app) {
        app.events().subscribe((Object)this);
    }

    @Observes(value={"failure", "stop"}, kind=Observes.Kind.critical)
    void monitorApplication(ApplicationLifecycle lifecycle) {
        this.context.lifecycle().tryMoveTo(ContainerState.partActive);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean shutdown) {
        if (this.context == null) {
            return;
        }
        log.info("stopping container management");
        try {
            this.context.lifecycle().tryMoveTo(shutdown ? ContainerState.down : ContainerState.stopped);
            this.stopHandlers();
            log.info("stopping container events");
            this.context.events().stop();
            Utils.scheduledServicePool.shutdownNow();
        }
        catch (RuntimeException e) {
            log.warn("cannot stop container management (see cause)", (Throwable)e);
        }
    }

    private void startHandlers(List<ContainerHandler> handlers) {
        try {
            this.pipeline = new ContainerPipeline(handlers);
            this.pipeline.forward(new ContainerLifecycleEvent.Start(this.context));
        }
        catch (RuntimeException e) {
            this.context.lifecycle().tryMoveTo(ContainerState.failed);
            throw e;
        }
    }

    private void stopHandlers() {
        if (this.pipeline == null) {
            return;
        }
        ContainerPipeline returnPipeline = this.pipeline.reverse();
        returnPipeline.forward(new ContainerLifecycleEvent.Stop(this.context));
    }
}

