/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.relations;

import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.types.impl.TypeImpl;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.impl.relations.ConsistsOfTypeImpl;
import org.gcube.informationsystem.types.impl.relations.IsRelatedToTypeImpl;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.relations.RelationType;

@JsonTypeName(value="RelationType")
public class RelationTypeImpl<S extends EntityType, T extends EntityType>
extends TypeImpl
implements RelationType<S, T> {
    private static final long serialVersionUID = 2221831081869571296L;
    protected S source;
    protected T target;

    protected RelationTypeImpl() {
    }

    public static RelationType<?, ?> getRelationTypeDefinitionInstance(Class<? extends RelationElement<?, ?>> clz) {
        if (IsRelatedTo.class.isAssignableFrom(clz)) {
            Class<? extends RelationElement<?, ?>> c = clz;
            return new IsRelatedToTypeImpl((Class<? extends IsRelatedTo<? extends Resource, ? extends Resource>>)c);
        }
        if (ConsistsOf.class.isAssignableFrom(clz)) {
            Class<? extends RelationElement<?, ?>> c = clz;
            return new ConsistsOfTypeImpl((Class<? extends ConsistsOf<? extends Resource, ? extends Facet>>)c);
        }
        return new RelationTypeImpl((Class<? extends RelationElement<?, ?>>)((Class<RelationElement<?, ?>>)clz));
    }

    public RelationTypeImpl(Class<? extends RelationElement<?, ?>> clz) {
        super(clz);
        if (RelationType.class.isAssignableFrom(clz)) {
            Class<? extends RelationElement<?, ?>> c = clz;
            this.extendedTypes = this.retrieveSuperClasses(c, RelationType.class, "RelationElement");
        } else if (IsParentOf.class.isAssignableFrom(clz)) {
            Class<? extends RelationElement<?, ?>> c = clz;
            this.extendedTypes = this.retrieveSuperClasses(c, IsParentOf.class, "RelationElement");
        } else if (RelationElement.class.isAssignableFrom(clz)) {
            this.extendedTypes = this.retrieveSuperClasses(clz, RelationElement.class, null);
        } else {
            throw new RuntimeException("Type Hierachy Error");
        }
        this.properties = this.retrieveListOfProperties(clz);
        this.discoverSourceAndTarget(clz);
    }

    protected Type[] getParametersFromSuperClasses(Class<? extends RelationElement<?, ?>> clz) {
        for (Type t : clz.getGenericInterfaces()) {
            if (t instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)t;
                if (!RelationElement.class.isAssignableFrom((Class)type.getRawType())) continue;
                return type.getActualTypeArguments();
            }
            if (!RelationElement.class.isAssignableFrom((Class)t)) continue;
            return this.getParametersFromSuperClasses((Class)t);
        }
        throw new RuntimeException("Unable to find Generic Parameters From SuperClasses to set source and target");
    }

    private void discoverSourceAndTarget(Class<? extends RelationElement<?, ?>> clz) {
        Class targetClass;
        Class sourceClass;
        Type[] typeParameters = clz.getTypeParameters();
        if (typeParameters.length == 0) {
            typeParameters = this.getParametersFromSuperClasses(clz);
            sourceClass = (Class)typeParameters[0];
            targetClass = (Class)typeParameters[1];
        } else {
            sourceClass = this.getGenericClass(typeParameters[0]);
            targetClass = this.getGenericClass(typeParameters[1]);
        }
        this.source = new EntityTypeImpl(sourceClass);
        this.target = new EntityTypeImpl(targetClass);
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public void setSource(S source) {
        this.source = source;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(T target) {
        this.target = target;
    }

    @Override
    @JsonIgnore
    public AccessType getAccessType() {
        if (this.name.compareTo("IsParentOf") == 0) {
            return AccessType.IS_PARENT_OF;
        }
        if (this.name.compareTo("RelationElement") == 0) {
            return AccessType.RELATION_ELEMENT;
        }
        if (this.name.compareTo("RelationType") == 0 || this.name.compareTo("IsRelatedToType") == 0 || this.name.compareTo("ConsistsOfType") == 0) {
            return AccessType.RELATION_TYPE;
        }
        return AccessType.RELATION;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            ElementMapper.marshal(this, stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            try {
                ElementMapper.marshal(this.metadata, stringWriter);
                return stringWriter.toString();
            }
            catch (Exception e1) {
                return super.toString();
            }
        }
    }
}

