/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.gcube.keycloak.protocol.oidc.tip.TIPConfiguration;
import org.gcube.keycloak.protocol.oidc.tip.TIPConfigurationException;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

public class EOSCNodeAccessTokenIntrospectionProvider<T extends AccessToken>
extends AccessTokenIntrospectionProvider
implements TokenIntrospectionProvider {
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final Logger logger = Logger.getLogger(EOSCNodeAccessTokenIntrospectionProvider.class);
    protected static String serverIssuer;
    protected final Configuration eoscNodeConfiguration;

    public EOSCNodeAccessTokenIntrospectionProvider(KeycloakSession session, Configuration eoscNodeConfiguration) {
        super(session);
        if (serverIssuer == null) {
            serverIssuer = Urls.realmIssuer((URI)session.getContext().getUri().getBaseUri(), (String)session.getContext().getRealm().getName());
            logger.infof("Keycloak server instance 'issuer' is: %s", (Object)serverIssuer);
        }
        this.eoscNodeConfiguration = eoscNodeConfiguration;
    }

    public void close() {
        super.close();
    }

    public Response introspect(String accessTokenString, EventBuilder eventBuilder) {
        if (!this.eoscNodeConfiguration.isConfigured()) {
            logger.trace((Object)"Provider is not configured, continue with default introspection");
            return super.introspect(accessTokenString, eventBuilder);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Getting the issuer from the access token");
        }
        String tokenIssuer = this.getAccessTokenIssuer(accessTokenString, eventBuilder);
        logger.tracef("Access token issued by: %s", (Object)tokenIssuer);
        if (serverIssuer.equals(tokenIssuer)) {
            logger.debug((Object)"Token is issued by this server, continue introspection with superclass' method");
            return super.introspect(accessTokenString, eventBuilder);
        }
        logger.debug((Object)"Token is NOT issued by this server, continue introspection on remote node/MyAccess");
        return this.performRemoteNodeIntrospection(tokenIssuer, accessTokenString, eventBuilder);
    }

    protected String getAccessTokenIssuer(String accessTokenString, EventBuilder eventBuilder) {
        try {
            logger.debug((Object)"Deserializing the recevide access token and getting issuer");
            return ((AccessToken)new JWSInput(accessTokenString).readJsonContent(AccessToken.class)).getIssuer();
        }
        catch (JWSInputException e) {
            logger.debug((Object)"Can't deserialize access token from string", (Throwable)e);
            eventBuilder.detail("reason", "Can't deserialize access token from string. Reason: " + e.getMessage());
            eventBuilder.error("token_introspection_failed");
            throw new RuntimeException("Error parsing access token string to get the issuer", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response performRemoteNodeIntrospection(String issuerURL, String accessTokenString, EventBuilder eventBuilder) {
        TIPConfiguration.Config.TipConfig.RemoteIssuer remoteIssuer = this.eoscNodeConfiguration.findRemoteIssuer(issuerURL);
        if (remoteIssuer != null && remoteIssuer.getIntrospection_endpoint() != null) {
            String introspectionEndpointURL = remoteIssuer.getIntrospection_endpoint();
            logger.debugf("Remote endpoint introspection URL is: %s", (Object)introspectionEndpointURL);
            logger.trace((Object)"Creating and perfom POST with the HTTP client");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Starting HTTP POST creation");
                }
                HttpPost httpPost = new HttpPost(introspectionEndpointURL);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Setting the Authorization header");
                }
                httpPost.setHeader("Authorization", BasicAuthHelper.createHeader((String)remoteIssuer.getClient_id(), (String)remoteIssuer.getClient_secret()));
                ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
                form.add(new BasicNameValuePair("token", accessTokenString));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, StandardCharsets.UTF_8);
                httpPost.setEntity((HttpEntity)entity);
                if (logger.isTraceEnabled()) {
                    logger.tracef("Setting connection timeout to %d millis", 5000);
                    logger.tracef("Setting socket timeout to %d millis", 10000);
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).build();
                httpPost.setConfig(requestConfig);
                logger.debug((Object)"Performing the request...");
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                    String responseBodyString;
                    int statusCode = response.getStatusLine().getStatusCode();
                    logger.debugf("Resulting status code is %d", statusCode);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Getting the response entity");
                    }
                    HttpEntity responseEntity = response.getEntity();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Reading the response body");
                    }
                    String string = responseBodyString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "";
                    if (statusCode >= 200 && statusCode < 300) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Deserializing JSON as object node");
                        }
                        ObjectNode responseObjectNode = (ObjectNode)JsonSerialization.mapper.readTree(responseBodyString);
                        byte[] responseBytes = null;
                        if (responseObjectNode.get("active").asBoolean() && this.eoscNodeConfiguration.tokenShouldBeManipulated(remoteIssuer)) {
                            logger.debug((Object)"Token is active and should be manipulated before returning it");
                            this.dropClaims(remoteIssuer, responseObjectNode);
                            this.renameClaims(remoteIssuer, responseObjectNode);
                            this.mapClaims(remoteIssuer, responseObjectNode);
                            if (logger.isTraceEnabled()) {
                                logger.tracef("Resulting response JSON string is: %s", (Object)JsonSerialization.writeValueAsPrettyString((Object)responseObjectNode));
                            }
                            if (logger.isTraceEnabled()) {
                                logger.tracef("Serializing response JSON object node as byte[]", new Object[0]);
                            }
                            responseBytes = JsonSerialization.writeValueAsBytes((Object)responseObjectNode);
                        } else {
                            responseBytes = responseBodyString.getBytes();
                        }
                        eventBuilder.success();
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Returning OK reponse, streaming back the remote introspection response JSON", new Object[0]);
                        }
                        Response response2 = Response.ok((Object)responseBytes).type(MediaType.APPLICATION_JSON_TYPE).build();
                        return response2;
                    }
                    logger.errorf("MyAccess server response is not OK [%d]: %s", (Object)statusCode, (Object)responseBodyString);
                    eventBuilder.detail("reason", responseBodyString);
                    eventBuilder.error("token_introspection_failed");
                    throw new RuntimeException("Error calling MyAccess for token introspection");
                }
            }
            catch (IOException e) {
                logger.error((Object)"An errord occurred performing the token introspection on MyAccess", (Throwable)e);
                eventBuilder.detail("reason", e.getMessage());
                eventBuilder.error("token_introspection_failed");
                throw new RuntimeException("Error performing the token introspection on MyAccess", e);
            }
        }
        logger.warnf("Cannot perform remote node introspection since the endpoint URL is unknown for issuer: %s", (Object)issuerURL);
        return Response.ok((Object)Configuration.DEFAULT_RESPONSE_ON_UNKNOWN_ISSUER_ENDPOINT).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void dropClaims(TIPConfiguration.Config.TipConfig.RemoteIssuer remoteIssuer, ObjectNode introspectionResponse) {
        List<String> dropClaims = remoteIssuer.getDrop_claims();
        if (dropClaims != null && !dropClaims.isEmpty()) {
            logger.debug((Object)"Performing the claim dropping...");
            for (String claimName : dropClaims) {
                if (introspectionResponse.has(claimName)) {
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Dropping '%s' claim", (Object)claimName);
                    }
                    introspectionResponse.remove(claimName);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.tracef("Claim not found in token: %s", (Object)claimName);
            }
        } else {
            logger.debug((Object)"Drop claims is not configured");
        }
    }

    protected void renameClaims(TIPConfiguration.Config.TipConfig.RemoteIssuer remoteIssuer, ObjectNode introspectionResponse) {
        Map<String, String> claimRenamings = remoteIssuer.getClaim_renaming();
        if (claimRenamings != null && !claimRenamings.isEmpty()) {
            logger.debug((Object)"Performing the claim renaming...");
            for (String originalClaimName : claimRenamings.keySet()) {
                String newClaimName = claimRenamings.get(originalClaimName);
                if (introspectionResponse.has(originalClaimName)) {
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Renaming the '%s' claim to '%s'", (Object)originalClaimName, (Object)newClaimName);
                    }
                    introspectionResponse.set(newClaimName, introspectionResponse.get(originalClaimName));
                    introspectionResponse.remove(originalClaimName);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.tracef("Claim not found in token: %s", (Object)originalClaimName);
            }
        } else {
            logger.debug((Object)"Claim renaming is not configured");
        }
    }

    protected void mapClaims(TIPConfiguration.Config.TipConfig.RemoteIssuer remoteIssuer, ObjectNode introspectionResponse) {
        TIPConfiguration.Config.TipConfig.RemoteIssuer.ClaimMapping claimMapping = remoteIssuer.getClaim_mapping();
        if (claimMapping != null) {
            Map<String, Map<String, List<String>>> stringArraysMapping;
            Map<String, Map<String, String>> stringMapping = claimMapping.getStrings();
            if (stringMapping != null && !stringMapping.isEmpty()) {
                logger.debug((Object)"Performing the string claim mapping...");
                for (String claimName : stringMapping.keySet()) {
                    if (introspectionResponse.has(claimName)) {
                        logger.debugf("Mapping '%s' claim values...", (Object)claimName);
                        JsonNode claimNode = introspectionResponse.get(claimName);
                        if (claimNode.isTextual()) {
                            String claimValue = claimNode.asText();
                            if (!stringMapping.get(claimName).containsKey(claimValue)) continue;
                            String newValue = stringMapping.get(claimName).get(claimValue);
                            logger.tracef("Mapping '%s' to '%s'", (Object)claimValue, (Object)newValue);
                            introspectionResponse.set(claimName, (JsonNode)introspectionResponse.textNode(newValue));
                            continue;
                        }
                        logger.debug((Object)"Claim node is not a textual node");
                        continue;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.tracef("Claim not found in token: %s", (Object)claimName);
                }
            }
            if ((stringArraysMapping = claimMapping.getString_arrays()) != null && !stringArraysMapping.isEmpty()) {
                logger.debug((Object)"Performing the string arrays claim mapping...");
                for (String claimName : stringArraysMapping.keySet()) {
                    if (introspectionResponse.has(claimName)) {
                        logger.debugf("Mapping '%s' claim array values...", (Object)claimName);
                        JsonNode claimNode = introspectionResponse.get(claimName);
                        if (claimNode.isArray() && claimNode.size() > 0 && claimNode.get(0).isTextual()) {
                            ArrayNode claimArrayNode = (ArrayNode)claimNode;
                            ArrayNode newClaimArrayNode = introspectionResponse.arrayNode();
                            for (int i = 0; i < claimArrayNode.size(); ++i) {
                                TextNode claimValueAtI = (TextNode)claimArrayNode.get(i);
                                String claimValue = claimArrayNode.get(i).asText();
                                if (stringArraysMapping.get(claimName).containsKey(claimValue)) {
                                    List<String> newValues = stringArraysMapping.get(claimName).get(claimValue);
                                    logger.tracef("Mapping '%s' to '%s'", (Object)claimValue, newValues);
                                    for (String newValue : newValues) {
                                        newClaimArrayNode.add((JsonNode)introspectionResponse.textNode(newValue));
                                    }
                                    continue;
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.tracef("Calim value not found in array: ", (Object)claimValue);
                                }
                                newClaimArrayNode.add((JsonNode)claimValueAtI);
                            }
                            continue;
                        }
                        logger.debug((Object)"Claim node is not an array of strings or is empty");
                        continue;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.tracef("Claim not found in token: %s", (Object)claimName);
                }
            }
        } else {
            logger.debug((Object)"Claim mapping is not set");
        }
    }

    public static class Configuration {
        public static final byte[] DEFAULT_RESPONSE_ON_UNKNOWN_ISSUER_ENDPOINT = "{\"active\": false}".getBytes();
        private TIPConfiguration tipConfiguration = null;

        public Configuration(Config.Scope config) {
            String yamlConfigFile = config.get("yaml-config-file");
            if (yamlConfigFile != null) {
                try {
                    this.tipConfiguration = TIPConfiguration.loadFromYAML(yamlConfigFile);
                }
                catch (TIPConfigurationException e) {
                    logger.warn((Object)("Cannot load TIP config file from: " + yamlConfigFile), (Throwable)e);
                }
            } else {
                logger.info((Object)"YAML file configuration not provided");
            }
        }

        public boolean isConfigured() {
            return this.tipConfiguration != null;
        }

        public TIPConfiguration.Config.TipConfig.RemoteIssuer findRemoteIssuer(String issuerURL) {
            if (this.tipConfiguration != null) {
                if (issuerURL != null) {
                    return this.tipConfiguration.getTip().getRemote_issuers() != null ? this.tipConfiguration.getTip().getRemote_issuers().stream().filter(remoteIssuer -> issuerURL.equals(remoteIssuer.getIssuer_url())).findFirst().orElse(this.tipConfiguration.getTip().getFallback_issuer_unknown_token_issuer()) : this.tipConfiguration.getTip().getFallback_issuer_unknown_token_issuer();
                }
                return this.tipConfiguration.getTip().getFallback_issuer_unsupported_token_issuer();
            }
            return null;
        }

        public boolean tokenShouldBeManipulated(TIPConfiguration.Config.TipConfig.RemoteIssuer remoteIssuer) {
            return remoteIssuer.getDrop_claims() != null && !remoteIssuer.getDrop_claims().isEmpty() || remoteIssuer.getClaim_renaming() != null && !remoteIssuer.getClaim_renaming().isEmpty() || remoteIssuer.getClaim_mapping() != null && remoteIssuer.getClaim_mapping().getStrings() != null && !remoteIssuer.getClaim_mapping().getStrings().isEmpty() || remoteIssuer.getClaim_mapping() != null && remoteIssuer.getClaim_mapping().getString_arrays() != null && !remoteIssuer.getClaim_mapping().getString_arrays().isEmpty();
        }
    }
}

