package org.gcube.informationsystem.resourceregistry.api.exceptions;

import java.io.Serial;

/**
 * The Class AvailableInAnotherContextException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class AvailableInAnotherContextException extends ResourceRegistryException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -7499131763751652582L;

	/**
	 * Instantiates a new available in another context exception.
	 *
	 * @param message the message
	 */
	public AvailableInAnotherContextException(String message) {
		super(message);
	}
	
	/**
	 * Instantiates a new available in another context exception.
	 *
	 * @param cause the cause
	 */
	public AvailableInAnotherContextException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new available in another context exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public AvailableInAnotherContextException(String message, Throwable cause) {
		super(message, cause);
	}

}
