package org.gcube.informationsystem.resourceregistry.api.exceptions.contexts;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;

/**
 * The Class ContextAlreadyPresentException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class ContextAlreadyPresentException extends AlreadyPresentException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -3185950257529005913L;

	/**
	 * Instantiates a new context already present exception.
	 *
	 * @param message the message
	 */
	public ContextAlreadyPresentException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new context already present exception.
	 *
	 * @param cause the cause
	 */
	public ContextAlreadyPresentException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new context already present exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ContextAlreadyPresentException(String message, Throwable cause) {
		super(message, cause);
	}

}
