package org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;

/**
 * The Class QueryTemplateNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class QueryTemplateNotFoundException extends NotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 3034336911176161784L;

	/**
	 * Instantiates a new query template not found exception.
	 *
	 * @param message the message
	 */
	public QueryTemplateNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new query template not found exception.
	 *
	 * @param cause the cause
	 */
	public QueryTemplateNotFoundException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new query template not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public QueryTemplateNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

}
