package org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isparentof;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationAlreadyPresentException;

/**
 * The Class IsParentOfAlreadyPresentException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsParentOfAlreadyPresentException extends RelationAlreadyPresentException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -244592605626665740L;

	/**
	 * Instantiates a new checks if is parent of already present exception.
	 *
	 * @param message the message
	 */
	public IsParentOfAlreadyPresentException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new checks if is parent of already present exception.
	 *
	 * @param cause the cause
	 */
	public IsParentOfAlreadyPresentException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new checks if is parent of already present exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public IsParentOfAlreadyPresentException(String message, Throwable cause) {
		super(message, cause);
	}

}
