/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.model.reference.properties.Encrypted;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.utils.TypeUtility;

public class EncryptedOrient
extends ODocument
implements Encrypted {
    public static final String NAME = "Encrypted";
    public static final String VALUE = "value";
    protected String decryptedValue;
    protected String dbEncryptedValue;
    protected String contextEncryptedValue;

    public EncryptedOrient() {
        super(NAME);
    }

    protected EncryptedOrient(String iClassName) {
        super(iClassName);
    }

    public String getTypeName() {
        return TypeUtility.getTypeName(this.getClass());
    }

    public List<String> getSupertypes() {
        TypesCache typesCache = TypesCache.getInstance();
        CachedType cachedType = typesCache.getCachedType(this.getTypeName());
        try {
            return cachedType.getSuperTypes();
        }
        catch (Exception e) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TypeUtility.getTypeName(Property.class));
            return list;
        }
    }

    public String getExpectedtype() {
        return null;
    }

    public String getEncryptedValue() {
        return (String)this.field(VALUE);
    }

    public void setEncryptedValue(String encryptedValue) {
        this.field(VALUE, (Object)encryptedValue);
    }

    public String getDecryptedValue() {
        return this.decryptedValue;
    }

    public String getDbEncryptedValue() {
        return this.dbEncryptedValue;
    }

    public String getContextEncryptedValue() {
        return this.contextEncryptedValue;
    }

    public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
        this.decryptedValue = decryptedValue;
        Key databaseKey = DatabaseEnvironment.getDatabaseKey();
        this.dbEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue, databaseKey);
        this.contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
        if (setEncryptedForContext) {
            this.setEncryptedValue(this.contextEncryptedValue);
        } else {
            this.setEncryptedValue(this.dbEncryptedValue);
        }
    }

    public Map<String, Object> getAdditionalProperties() {
        return null;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
    }

    public Object getAdditionalProperty(String key) {
        return null;
    }

    public void setAdditionalProperty(String key, Object value) {
    }

    public String getValue() {
        return this.getEncryptedValue();
    }

    public void setValue(String value) {
        this.setEncryptedValue(value);
    }

    public String toJSON(String iFormat) {
        String ret = super.toJSON(iFormat);
        ret = OrientDBUtility.replaceType((String)ret);
        return ret;
    }
}

