/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.utils.UUIDUtility;
import org.gcube.informationsystem.utils.TypeUtility;

@Path(value="sharing")
@Tag(name="Sharing", description="Operations for sharing and unsharing instances between contexts.")
public class SharingManager
extends BaseRest {
    protected String serializeAffectedInstaces(ObjectMapper objectMapper, Map<UUID, JsonNode> affectedInstances) throws ResourceRegistryException {
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (JsonNode jsonNode : affectedInstances.values()) {
            arrayNode.add(jsonNode);
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String addRemoveNoPropagationConstraint(@PathParam(value="context-uuid") String contextId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @QueryParam(value="forceAddToContext") @DefaultValue(value="false") Boolean forceAddToContext, String body) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllIncludeQueryParameters();
        try {
            StringBuffer calledMethod = new StringBuffer();
            if (dryRun == null) {
                dryRun = false;
            }
            if (dryRun.booleanValue()) {
                calledMethod.append("dryRun");
            }
            if (operation == SharingPath.SharingOperation.ADD) {
                this.logger.info("Requested {} {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", body, "Context", contextId});
                calledMethod.append("AddToContext");
            } else {
                this.logger.info("Requested {} {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", body, "Context", contextId});
                calledMethod.append("RemoveFromContext");
            }
            calledMethod.append("NoPropagationConstraint");
            this.setAccountingMethod(calledMethod.toString());
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = (ArrayNode)objectMapper.readTree(body);
            HashMap<UUID, JsonNode> expectedInstances = new HashMap<UUID, JsonNode>();
            for (JsonNode node : arrayNode) {
                String type = TypeUtility.getTypeName((JsonNode)node);
                UUID uuid = UUIDUtility.getUUID((JsonNode)node);
                expectedInstances.put(uuid, node);
            }
            UUID contextUUID = UUID.fromString(contextId);
            Map affectedInstances = null;
            if (operation == SharingPath.SharingOperation.ADD) {
                // empty if block
            }
            return this.serializeAffectedInstaces(objectMapper, affectedInstances);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @POST
    @Path(value="/contexts/{context-uuid}/{type-name}/{instance-uuid}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Add or Remove Instance from Context", description="Add or remove an instance from a context. The operation can have a cascade effect due to propagation constraints.\nReturns the list of instances affected by the add/remove operation on the target instance identified by UUID path parameter.\n\n\n**Request Examples:**\n- POST /sharing/contexts/67062c11-9c3a-4906-870d-7df6a43408b0/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8?operation=ADD (add HostingNode to context);\n- POST /sharing/contexts/67062c11-9c3a-4906-870d-7df6a43408b0/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8?operation=REMOVE (remove HostingNode from context);\n- POST /sharing/contexts/67062c11-9c3a-4906-870d-7df6a43408b0/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8?operation=ADD&dryRun=true (preview what would be affected by adding HostingNode);\n- POST /sharing/contexts/67062c11-9c3a-4906-870d-7df6a43408b0/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8?operation=ADD&forceAddToContext=true (force add even if instance is not in current context);\n- POST /sharing/contexts/67062c11-9c3a-4906-870d-7df6a43408b0/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8?operation=ADD&includeMeta=true&includeContexts=true (add with metadata and context information in response).\n\nWhere:\n- 67062c11-9c3a-4906-870d-7df6a43408b0 is the Context UUID;\n- 16032d09-3823-444e-a1ff-a67de4f350a8 is the HostingNode UUID.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can perform ADD/REMOVE operations on any instance in any context;\n\t- Can use forceAddToContext=true to add instances from other contexts;\n\t- Full administrative privileges across all contexts;\n\t- See complete metadata including sensitive information (createdBy, lastUpdatedBy) when includeMeta=true.\n\n- **Infrastructure-Manager:**\n\t- Can perform ADD/REMOVE operations on any instance in any context;\n\t- Can use forceAddToContext=true to add instances from other contexts;\n\t- Full administrative privileges across all contexts;\n\t- See complete metadata including sensitive information (createdBy, lastUpdatedBy) when includeMeta=true.\n\n- **Other Users:**\n\t- Can perform ADD/REMOVE operations only on instances accessible in their current context;\n\t- Cannot use forceAddToContext=true (parameter is ignored if provided);\n\t- Operations are limited to instances they have access to in their authorized context;\n\t- See filtered metadata with sensitive fields obfuscated when includeMeta=true.\n\n\n**Operation Behavior:**\n- **Propagation Constraints and Cascade Effects:**\n\t- **ADD Operation Cascading:** When an instance is added to a context, related instances may also be automatically added due to propagation constraints;\n\t- **REMOVE Operation Cascading:** When an instance is removed from a context, related instances may also be automatically removed due to propagation constraints;\n\t- The response includes all instances that were added/removed as part of the cascade effect;\n\t- Propagation follows the schema-defined relationships and their constraints.\n\n- **Schema Validation for ConsistsOf Relations and Facets:**\n\t- When operations are performed on ConsistsOf relations or Facet instances, the parent Resource is automatically validated against its schema definition;\n\t- If the Resource is no longer compliant with its schema after the add/remove operation, a SchemaViolationException is thrown;\n\t- This results in an HTTP 400 Bad Request response with details about the schema violation;\n\t- **Example scenarios that violate schema constraints:**\n\t\t- Removing a required/mandatory Facet or ConsistsOf relation from a Resource;\n\t\t- Adding/removing instances that violate cardinality constraints (min/max occurrences) defined in the schema.\n\t- All these scenarios make the Resource incomplete or invalid according to its schema definition;\n\t- **Constraint Sources**: Constraints are defined by the specific type definitions that have been installed on the system;\n\t- Schema validation ensures the integrity and consistency by enforcing the constraints defined in each type's schema during operations.\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Operation completed successfully (instances added/removed)", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Schema validation failed (SchemaViolationException) - occurs when operation would violate schema constraints"), @APIResponse(responseCode="404", description="Instance, type, or context not found"), @APIResponse(responseCode="403", description="Insufficient permissions to perform the operation")})
    public String addRemove(@PathParam(value="context-uuid") String contextId, @PathParam(value="type-name") String type, @PathParam(value="instance-uuid") String instanceId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @QueryParam(value="forceAddToContext") @DefaultValue(value="false") Boolean forceAddToContext) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllIncludeQueryParameters();
        StringBuffer calledMethod = new StringBuffer();
        if (dryRun == null) {
            dryRun = false;
        }
        if (dryRun.booleanValue()) {
            calledMethod.append("dryRun");
        }
        if (operation == SharingPath.SharingOperation.ADD) {
            this.logger.info("Requested {} {} with UUID {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", type, instanceId, "Context", contextId});
            calledMethod.append("AddToContext");
        } else {
            this.logger.info("Requested {} {} with UUID {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", type, instanceId, "Context", contextId});
            calledMethod.append("RemoveFromContext");
        }
        this.setAccountingMethod(calledMethod.toString());
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        erManagement.setDryRun(dryRun.booleanValue());
        UUID contextUUID = UUID.fromString(contextId);
        if (operation == SharingPath.SharingOperation.ADD) {
            ((ERManagement)erManagement).setForceAddToContext(forceAddToContext);
            ((ERManagement)erManagement).addToContext(contextUUID);
        } else {
            ((ERManagement)erManagement).removeFromContext(contextUUID);
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return this.serializeAffectedInstaces(objectMapper, erManagement.getAffectedInstances());
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }
}

