/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.resolvers.query;

import java.util.HashMap;
import java.util.Map;
import org.gcube.portlets.user.uriresolvermanager.resolvers.query.GeoportalResolverQueryString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeoportalResolverQueryStringBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(GeoportalResolverQueryStringBuilder.class);
    public static final String ITEM_TYPE_PARAMETER = "item_type";
    public static final String ITEM_ID_PARAMETER = "item_id";
    public static final String GCUBE_SCOPE_PARAMETER = "gcube_scope";
    public static final String RESOLVE_AS_PARAMETER = "res";
    public static final String TARGET_APP_AS_PARAMETER = "target_app";
    private String itemType;
    private String itemId;
    private String gcubeScope;
    private RESOLVE_AS resolveAs;
    private TARGET_GEOPORTAL_APP targetApp;

    public GeoportalResolverQueryStringBuilder(String itemType, String itemId) {
        this.itemType = itemType;
        this.itemId = itemId;
    }

    public GeoportalResolverQueryStringBuilder scope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
        return this;
    }

    public GeoportalResolverQueryStringBuilder resolverAs(RESOLVE_AS resolveAs) {
        this.resolveAs = resolveAs;
        return this;
    }

    public GeoportalResolverQueryStringBuilder targetApp(TARGET_GEOPORTAL_APP targetApp) {
        this.targetApp = targetApp;
        return this;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public RESOLVE_AS getResolveAs() {
        return this.resolveAs;
    }

    public TARGET_GEOPORTAL_APP getTargetApp() {
        return this.targetApp;
    }

    public Map<String, String> buildQueryParameters() {
        GeoportalResolverQueryString crQS = new GeoportalResolverQueryString(this);
        if (crQS.getItemType() == null || crQS.getItemType().isEmpty()) {
            throw new IllegalArgumentException("The item_type cannot be null or empty");
        }
        if (crQS.getItemId() == null || crQS.getItemId().isEmpty()) {
            throw new IllegalArgumentException("The item_id cannot be null or empty");
        }
        if (crQS.getGcubeScope() == null || crQS.getGcubeScope().isEmpty()) {
            throw new IllegalArgumentException("The gcube_scope cannot be null or empty");
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put(ITEM_TYPE_PARAMETER, crQS.getItemType());
        query.put(ITEM_ID_PARAMETER, crQS.getItemId());
        query.put(GCUBE_SCOPE_PARAMETER, crQS.getGcubeScope());
        if (crQS.getResolveAs() != null) {
            query.put(RESOLVE_AS_PARAMETER, crQS.getResolveAs());
        }
        if (crQS.getTargetApp() != null) {
            query.put(TARGET_APP_AS_PARAMETER, crQS.getTargetApp());
        }
        return query;
    }

    public static enum RESOLVE_AS {
        PUBLIC("public"),
        PRIVATE("private");

        String paramValue;

        private RESOLVE_AS(String paramValue) {
            this.paramValue = paramValue;
        }

        public String getParamValue() {
            return this.paramValue;
        }
    }

    public static enum TARGET_GEOPORTAL_APP {
        GEO_DV("dv", "Geoportal Data-Viewer"),
        GEO_DE("de", "Geoportal Data-Entry");

        private String targetPath;
        private String applicationName;

        private TARGET_GEOPORTAL_APP(String targetPath, String applicationName) {
            this.targetPath = targetPath;
            this.applicationName = applicationName;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public String getApplicationName() {
            return this.applicationName;
        }
    }
}

