package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ActionFacet;
import org.gcube.resourcemanagement.model.reference.properties.EnumStringProperty;

/**
 * Implementation of {@link ActionFacet}.
 * 
 * @author Manuele Simi (ISTI-CNR)
 *
 */
@JsonTypeName(value = ActionFacet.NAME)
public class ActionFacetImpl extends FacetImpl implements ActionFacet {

	@Serial
	private static final long serialVersionUID = -1749157426900635075L;
	
	/**
	 * Name of the action.
	 */
	protected String name;
	
	/**
	 * Type of action.
	 */
	protected EnumStringProperty type;
	
	/**
	 * A remote source used by the command. Could be the endpoint of a service, the location of a 
	 * remote ansible playbook, etc.
	 */
	protected String source;
	
	/**
	 * Options and parameters for the command.
	 */
	protected String options;
	
	/**
	 * The command to execute
	 */
	protected String command;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getSource() {
		return this.source;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return this.name;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSource(String source) {
		this.source = source;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getOptions() {
		return this.options;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setOptions(String options) {
		this.options = options;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setCommand(String command) {
		this.command = command;
		
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getCommand() {
		return this.command;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public EnumStringProperty getType() {
		return this.type;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setType(EnumStringProperty type) {
		this.type = type;
	}
	
}
