/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.ProvenanceFacetImpl;
import org.gcube.resourcemanagement.model.reference.properties.ValueSchema;

/**
 * ProvenanceFacet captures information on provenance/lineage of the entire resource.
 * It is mainly used to describe provenance information of a Dataset.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Provenance_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=ProvenanceFacetImpl.class)
@TypeMetadata(
	name = ProvenanceFacet.NAME, 
	description = "ProvenanceFacet captures information on provenance/lineage of the entire resource. "
			+ "It is mainly used to describe provenance information of a Dataset.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface ProvenanceFacet extends Facet {
	
	/** The name associated with this facet */
	public static final String NAME = "ProvenanceFacet"; // ProvenanceFacet.class.getSimpleName();
	
	/**
	 * Returns a default instance of ProvenanceFacet
	 * @return a default instance of ProvenanceFacet
	 */
	public static ProvenanceFacet getDefaultInstance() {
		return new ProvenanceFacetImpl();
	}

	/*
	public enum Relationship {
		wasDerivedFrom, wasGeneratedBy, ...
	}
	*/
	
	/**
	 * Relationship with the resource indicated by ID.
	 * @return the relationship
	 */
	@ISProperty(description = "Relationship with the resource indicated by ID. Please note that the provenance has not been modelled as IsRelatedTo specialization, because the source resource is not necessarly in the IS or could be deleted from the IS at any time.")
	public String getRelationship();
	
	/**
	 * Sets the Relationship with the resource indicated by ID.
	 * @param relationship the relationship
	 */
	public void setRelationship(String relationship);
	
	/**
	 * The ID of the referenced resource.
	 * @return the reference
	 */
	@ISProperty(description = "The ID of the referenced resource.")
	public String getReference();
	
	/**
	 * Sets the ID of the referenced resource.
	 * @param reference the reference
	 */
	public void setReference(String reference);
	
	/**
	 * Provenance Document, e.g., an XML according to the reference schema.
	 * @return the document
	 */
	@ISProperty(description = "Provenance Document, e.g., an XML according to the reference schema.")
	public ValueSchema getDocument();
	
	/**
	 * Sets the Provenance Document, e.g., an XML according to the reference schema.
	 * @param document the document
	 */
	public void setDocument(ValueSchema document);
	
}