/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.NetworkingFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=NetworkingFacet.NAME)
public class NetworkingFacetImpl extends FacetImpl implements NetworkingFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 4634990116645322204L;
	
	protected String hostName;
	protected String domainName;
	protected String ipAddress;
	protected String mask;
	protected String broadcastAddress;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getHostName() {
		return hostName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHostName(String hostName) {
		this.hostName = hostName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDomainName() {
		return domainName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getIPAddress() {
		return this.ipAddress;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setIPAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getMask() {
		return this.mask;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMask(String mask) {
		this.mask = mask;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getBroadcastAddress() {
		return this.broadcastAddress;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setBroadcastAddress(String broadcastAddress) {
		this.broadcastAddress = broadcastAddress;
	}

}
