/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=IsIdentifiedBy.NAME)
public class IsIdentifiedByImpl<S extends Resource, T extends Facet> extends
	ConsistsOfImpl<S, T> implements IsIdentifiedBy<S, T> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 8043666054054911145L;

	/**
	 * Protected default constructor
	 */
	protected IsIdentifiedByImpl(){
		super();
	}

	/**
	 * Creates an instance of IsIdentifiedBy
	 * @param source the source Resource
	 * @param target the target Facet
	 */
	public IsIdentifiedByImpl(S source, T target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of IsIdentifiedBy
	 * @param source the source Resource
	 * @param target the target Facet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public IsIdentifiedByImpl(S source, T target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
