/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=MemoryFacet.NAME)
public class MemoryFacetImpl extends FacetImpl implements MemoryFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 6670219616322243388L;
	
	/**
	 * The size of the memory
	 */
	protected long size;
	
	/**
	 * Thesize of used memory
	 */
	protected long used;

	/**
	 * The memory unit used to express size and used
	 */
	protected MemoryUnit unit;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public long getSize() {
		return this.size;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSize(long size) {
		this.size = size;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public long getUsed() {
		return this.used;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setUsed(long used) {
		this.used = used;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MemoryUnit getUnit() {
		return this.unit;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setUnit(MemoryUnit unit) {
		this.unit = unit;
	}

}
