/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=SoftwareFacet.NAME)
public class SoftwareFacetImpl extends FacetImpl implements SoftwareFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 1062768788238515868L;
	
	/**
	 * The name of the software
	 */
	protected String name;
	
	/**
	 * The group of the software
	 */
	protected String group;
	
	/**
	 * The version of the software
	 */
	protected String version;
	
	/**
	 * The description of the software
	 */
	protected String description;
	
	/**
	 * The qualifier of the software
	 */
	protected String qualifier;
	
	/**
	 * Whether the software is optional
	 */
	protected boolean optional;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getGroup() {
		return this.group;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setGroup(String group) {
		this.group = group;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getVersion() {
		return this.version;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return this.description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getQualifier() {
		return this.qualifier;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setQualifier(String qualifier) {
		this.qualifier = qualifier;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isOptional() {
		return this.optional;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setOptional(boolean optional) {
		this.optional = optional;
	}

}
