/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.IdentifierFacetImpl;

/**
 * IdentifierFacet captures information on identifiers (other than the 
 * ones automatically generated by the system) that can be attached to a resource.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Identifier_Facet
 * 
 * Changelog (only model changes are logged here. Not implementation details)
 * 
 * - 1.0.1 Added STRING in IdentificationType enum.
 * - 1.0.0 First version 
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=IdentifierFacetImpl.class)
@TypeMetadata(
	name = IdentifierFacet.NAME, 
	description = "IdentifierFacet captures information on identifiers (other than the ones "
			+ "automatically generated by the system) that can be attached to a resource.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface IdentifierFacet extends Facet {
	
	/** The name associated with this facet */
	public static final String NAME = "IdentifierFacet"; // IdentifierFacet.class.getSimpleName();
	
	/** The name of 'value' property */
	public static final String VALUE_PROPERTY = "value";
	/** The name of 'identificationType' property */
	public static final String IDENTIFICATION_TYPE_PROPERTY = "identificationType";
	
	/**
	 * Returns a default instance of IdentifierFacet
	 * @return a default instance of IdentifierFacet
	 */
	public static IdentifierFacet getDefaultInstance() {
		return new IdentifierFacetImpl();
	}

	/** Enumeration of possible identification types */
	public enum IdentificationType {
		/** Uniform Resource Identifier	*/
		URI,
		/** Digital Object Identifier */
		DOI, 
		/** Internationalized Resource Identifier */
		IRI,
		/** Uniform Resource Locator */
		URL, 
		/** Uniform Resource Name */
		URN, 
		/** Universally Unique Identifier */
		UUID, 
		/** String identifier */
		STRING
	}
	
	/**
	 * The identifier value
	 * @return the value
	 */
	@ISProperty(name=VALUE_PROPERTY, description = "The identifier", mandatory=true, nullable=false)
	public String getValue();
	
	/**
	 * Sets the identifier value
	 * @param value the value
	 */
	public void setValue(String value);
	
	/**
	 * The identification type
	 * @return the identification type
	 */
	@ISProperty(name = IDENTIFICATION_TYPE_PROPERTY, description = "The typology of identifier", mandatory=true, nullable=false)
	public IdentificationType getIdentificationType();
	
	/**
	 * Sets the identification type
	 * @param type the identification type
	 */
	public void setIdentificationType(IdentificationType type);
	
	/**
	 * To indicate whether the identifier is persistent or not
	 * @return true if the identifier is persistent, false otherwise
	 */
	@ISProperty(description = "To indicate whether the identifier is persistent or not")
	public boolean isPersistent();
	
	/**
	 * Sets whether the identifier is persistent or not
	 * @param persistent true if the identifier is persistent, false otherwise
	 */
	public void setPersistent(boolean persistent);
	
}