/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;
import java.net.URL;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.LicenseFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=LicenseFacet.NAME)
public class LicenseFacetImpl extends FacetImpl implements LicenseFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 415765991191430747L;
	
	/**
	 * The name of the license
	 */
	protected String name;
	
	/**
	 * The URL of the license text
	 */
	protected URL textURL;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public URL getTextURL() {
		return textURL;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTextURL(URL textURL) {
		this.textURL = textURL;
	}

}
