/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ProvenanceFacet;
import org.gcube.resourcemanagement.model.reference.properties.ValueSchema;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ProvenanceFacet.NAME)
public class ProvenanceFacetImpl extends FacetImpl implements ProvenanceFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 1014553736569877775L;
	
	/**
	 * The relationship describing the provenance
	 */
	protected String relationship;
	
	/**
	 * The reference to the provenance entity
	 */
	protected String reference;
	
	/**
	 * The document describing the provenance
	 */
	protected ValueSchema document;	
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRelationship() {
		return relationship;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRelationship(String relationship) {
		this.relationship = relationship;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getReference() {
		return reference;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setReference(String reference) {
		this.reference = reference;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ValueSchema getDocument() {
		return document;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDocument(ValueSchema document) {
		this.document = document;
	}
	
}
