/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.SchemaFacet;
import org.gcube.resourcemanagement.model.reference.properties.ValueSchema;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=SchemaFacet.NAME)
public class SchemaFacetImpl extends FacetImpl implements SchemaFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -3443862680728281477L;
	
	/**
	 * The name of the schema
	 */
	protected String name;
	
	/**
	 * The description of the schema
	 */
	protected String description;
	
	/**
	 * The schema itself
	 */
	protected ValueSchema schema;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return name;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return description;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public ValueSchema getSchema() {
		return schema;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSchema(ValueSchema schema) {
		this.schema = schema;
	}

}
