/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.CapabilityFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=CapabilityFacet.NAME)
public class CapabilityFacetImpl extends FacetImpl implements CapabilityFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -4036703255922676717L;
	
	/** 
	 * The name of the capability
	 */
	protected String name;

	/** 
	 * The description of the capability 
	 */
	protected String description;
	
	/** 
	 * The qualifier 
	 */
	protected String qualifier;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return this.description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getQualifier() {
		return this.qualifier;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setQualifier(String qualifier) {
		this.qualifier = qualifier;
	}

}
