package org.gcube.resourcemanagement.model.impl.properties;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.resourcemanagement.model.reference.properties.RegexProperty;

/**
 * Implementation for {@link RegexProperty}.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonTypeName(value=RegexProperty.NAME)
public class RegexPropertyImpl extends GCubePropertyImpl implements RegexProperty {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -8279692341196771526L;

	/**
	 * The value
	 */
	private String value;
	
	/**
	 * The type (regex pattern)
	 */
	protected String type;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getValue() {
		return this.value;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getSchema() {
		return this.type;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSchema(String type) {
		this.type = type;
	}

}
