package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasOwner;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = HasOwner.NAME)
public class HasOwnerImpl<Out extends Resource, In extends ContactFacet>
		extends HasContactImpl<Out, In> implements HasOwner<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -7980790874053216568L;

	/**
	 * Protected default constructor
	 */
	protected HasOwnerImpl() {
		super();
	}

	/**
	 * Creates an instance of HasOwner
	 * @param source the source Resource
	 * @param target the target ContactFacet
	 */
	public HasOwnerImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of HasOwner
	 * @param source the source Resource
	 * @param target the target ContactFacet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public HasOwnerImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
