/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.LocationFacetImpl;

/**
 * LocationFacet captures information on a physical area characterising the resource it
 * is associated with. This should not be confused with {@link CoverageFacet}
 * The LocationFacet provides information of a location (eventually using 
 * latitude and longitude), instead {@link CoverageFacet} provide a way to to define the spatial 
 * or the temporal extent the resource represent.
 * 
 * It is mainly used to locate a data centre or to the geographic references of a 
 * legal body playing the role of an actor in the infrastructure.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Location_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=LocationFacetImpl.class)
@TypeMetadata(
	name = LocationFacet.NAME, 
	description = "LocationFacet captures information on a physical area characterising the resource it is associated with. "
			+ "This should not be confused with {@link CoverageFacet}. "
			+ "The LocationFacet provides information of a location (eventually using latitude and longitude), "
			+ "instead {@link CoverageFacet} provide a way to to define the spatial or the temporal extent the resource represent. "
			+ "It is mainly used to locate a data centre or to the geographic references of a legal body playing "
			+ "the role of an actor in the infrastructure.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface LocationFacet extends Facet {

	/** The name associated with this facet */
	public static final String NAME = "LocationFacet"; // LocationFacet.class.getSimpleName();
	
	/**
	 * Returns a default instance of LocationFacet
	 * @return a default instance of LocationFacet
	 */
	public static LocationFacet getDefaultInstance() {
		return new LocationFacetImpl();
	}

	/**
	 * The English name of the country
	 * @return the country
	 */
	@ISProperty(description = "The English name of the country")
	public String getCountry();
	
	/**
	 * Sets the English name of the country
	 * @param country the country
	 */
	public void setCountry(String country);

	/**
	 * The City name
	 * @return the location
	 */
	@ISProperty(description = "The City name")
	public String getLocation();
	
	/**
	 * Sets the City name
	 * @param location the location
	 */
	public void setLocation(String location);
	
	/**
	 * Latitude
	 * @return the latitude
	 */
	@ISProperty(description = "Latitude")
	public String getLatitude();
	
	/**
	 * Sets the Latitude
	 * @param latitude the latitude
	 */
	public void setLatitude(String latitude);
	
	/**
	 * Longitude
	 * @return the longitude
	 */
	@ISProperty(description = "Longitude")
	public String getLongitude();
	
	/**
	 * Sets the Longitude
	 * @param longitude the longitude
	 */
	public void setLongitude(String longitude);
	
}