/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.queries.templates.reference.properties.QueryTemplateReference;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.entities.facets.DiscoveryFacetImpl;

@JsonDeserialize(as=DiscoveryFacetImpl.class)
@TypeMetadata(name="DiscoveryFacet", description="This facet defines a group of resources to be discovered and potentially selected for inclusion in a context. It enables dynamic resource discovery through queries and supports selection constraints.", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface DiscoveryFacet
extends Facet {
    public static final String NAME = "DiscoveryFacet";
    public static final String GROUP_PROPERTY = "group";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String MAX_PROPERTY = "max";
    public static final String MIN_PROPERTY = "min";
    public static final String QUERIES_PROPERTY = "queries";
    public static final String QUERY_TEMPLATES_PROPERTY = "queryTemplates";

    public static DiscoveryFacet getDefaultInstance() {
        return new DiscoveryFacetImpl();
    }

    @ISProperty(name="group", description="The name identifier of the resource group to discover. This serves as a unique identifier for organizing and categorizing discovered resources.", mandatory=true, nullable=false)
    public String getGroup();

    public void setGroup(String var1);

    @ISProperty(name="description", description="Human-readable description displayed to users explaining what type of resources will be discovered in this group")
    public String getDescription();

    public void setDescription(String var1);

    @ISProperty(name="min", description="Minimum number of resources that must be selected from this group. Default is 0 (optional selection).", readonly=false, mandatory=true, nullable=false, defaultValue="0")
    public int getMin();

    public void setMin(int var1);

    @ISProperty(name="max", description="Maximum number of resources that can be selected from this group. Null means unlimited selection.", readonly=false, mandatory=true, nullable=true, defaultValue="null")
    public Integer getMax();

    public void setMax(Integer var1);

    @ISProperty(name="queries", description="Array of JSON query objects used to discover resources. Each query is executed and results are combined (union of all query results).", readonly=false, mandatory=true, nullable=true, defaultValue="null")
    public ArrayNode getQueries();

    public void setQueries(ArrayNode var1);

    public void addQuery(ObjectNode var1);

    @ISProperty(name="queryTemplates", description="Array of query template references with parameters. These are named, reusable query definitions that can accept variables for dynamic resource discovery.", readonly=false, mandatory=true, nullable=true, defaultValue="null")
    public List<QueryTemplateReference> getQueryTemplates();

    public void setQueryTemplates(List<QueryTemplateReference> var1);

    public void addQueryTemplates(QueryTemplateReference var1);
}

