package org.gcube.resourcemanagement.model.impl.relations.isrelatedto;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.relations.IsRelatedToImpl;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.resources.Actor;
import org.gcube.resourcemanagement.model.reference.entities.resources.Dataset;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Involves;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = Involves.NAME)
public class InvolvesImpl<Out extends Dataset, In extends Actor> extends
		IsRelatedToImpl<Out, In> implements Involves<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 9146386734851684864L;

	/**
	 * Protected default constructor
	 */
	protected InvolvesImpl() {
		super();
	}

	/**
	 * Creates an instance of Involves
	 * @param source the source Dataset
	 * @param target the target Actor
	 */
	public InvolvesImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of Involves
	 * @param source the source Dataset
	 * @param target the target Actor
	 * @param propagationConstraint the Propagation Constraint
	 */
	public InvolvesImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
