package org.gcube.resourcemanagement.model.impl.relations.isrelatedto;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Uses;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = Uses.NAME)
public class UsesImpl<Out extends EService, In extends EService> extends
	CallsForImpl<Out, In> implements Uses<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 6454443849562485949L;

	/**
	 * Protected default constructor
	 */
	protected UsesImpl() {
		super();
	}

	/**
	 * Creates an instance of Uses
	 * @param source the source EService
	 * @param target the target EService
	 */
	public UsesImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of Uses
	 * @param source the source EService
	 * @param target the target EService
	 * @param propagationConstraint the Propagation Constraint
	 */
	public UsesImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
