package org.gcube.resourcemanagement.model.reference.properties;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.base.reference.Attribute;
import org.gcube.informationsystem.base.reference.AttributeDefinition;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.properties.AttributePropertyImpl;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=AttributePropertyImpl.class)
@TypeMetadata(
	name = AttributeProperty.NAME, 
	description = "This class model as property any attrbute must be instantiated.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface AttributeProperty extends GCubeProperty, AttributeDefinition {

	/** The name associated with this property */
	public static final String NAME = "AttributeProperty"; // AttributeProperty.class.getSimpleName();
	
	/**
	 * Returns a default instance of AttributeProperty
	 * @return a default instance of AttributeProperty
	 */
	public static AttributeProperty getDefaultInstance() {
		return new AttributePropertyImpl();
	}

	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.NAME_PROPERTY, description = "The name of the attribute property.", readonly = true, mandatory = true, nullable = false)
	@Override
	public String getName();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.DESCRIPTION_PROPERTY, readonly = false, mandatory = true, nullable = false)
	@Override
	public String getDescription();

	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = AttributeDefinition.MANDATORY_PROPERTY, readonly = false, mandatory = true, nullable = false, defaultValue = "false")
	@Override
	public boolean isMandatory();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = AttributeDefinition.NOT_NULL_PROPERTY, readonly = false, mandatory = true, nullable = false, defaultValue = "false")
	@Override
	public boolean isNotnull();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.MAX_PROPERTY, readonly = false, mandatory = true, nullable = false)
	@Override
	public Integer getMax();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.MIN_PROPERTY, readonly = false, mandatory = true, nullable = false)
	@Override
	public Integer getMin();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.REGEX_PROPERTY, readonly = false, mandatory = true, nullable = false)
	@Override
	public String getRegexp();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.PROPERTY_TYPE_PROPERTY, readonly = false, mandatory = true, nullable = false)
	@Override
	public String getPropertyType();
	
	/**
	 * {@inheritDoc}
	 */
	@ISProperty(name = Attribute.DEFAULT_VALUE_PROPERTY, readonly = false, mandatory = false, nullable = true)
	@Override
	public Object getDefaultValue();
	
}
