package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.facets.ActionFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasAction;

/**
 * An implementation of the {@link HasAction} relation.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonTypeName(value = HasAction.NAME)
public class HasActionImpl<Out extends Service, In extends ActionFacet> 
	extends ConsistsOfImpl<Out, In> implements HasAction<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -1028958506776410453L;

	/**
	 * Protected default constructor
	 */
	protected HasActionImpl() {
		super();
	}

	/**
	 * Creates an instance of HasAction
	 * @param source the source Service
	 * @param target the target ActionFacet
	 */
	public HasActionImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of HasAction
	 * @param source the source Service
	 * @param target the target ActionFacet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public HasActionImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
