/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.iam.D4ScienceIAMClientAuthn;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.AccessTokenSecret;
import org.gcube.common.security.secrets.Secret;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextTest {
    private static final Logger logger = LoggerFactory.getLogger(ContextTest.class);
    protected static final String CONFIG_INI_FILENAME = "config.ini";
    public static final String PARENT_DEFAULT_TEST_CONTEXT;
    public static final String DEFAULT_TEST_CONTEXT;
    public static final String ALTERNATIVE_TEST_CONTEXT;
    public static final String GCUBE;
    public static final String DEVSEC;
    public static final String DEVVRE;
    protected static final Properties properties;
    public static final String TYPE_PROPERTY_KEY = "type";
    public static final String USERNAME_PROPERTY_KEY = "username";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String CLIENT_ID_PROPERTY_KEY = "clientId";

    public static void set(Secret secret) throws RuntimeException {
        SecretManagerProvider.reset();
        SecretManagerProvider.set((Secret)secret);
    }

    public static void setContextByName(String fullContextName) {
        logger.debug("Going to set credentials for context {}", (Object)fullContextName);
        try {
            Secret secret = ContextTest.getSecret(fullContextName);
            ContextTest.set(secret);
        }
        catch (Exception e) {
            logger.error("Unable to set credentials for context {}", (Object)fullContextName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected static String getJWTAccessToken(String context) throws RuntimeException {
        try {
            logger.debug("Going to set credentials for context {}", (Object)context);
            Type type = Type.valueOf(properties.get(TYPE_PROPERTY_KEY).toString());
            String accessToken = null;
            int index = context.indexOf(47, 1);
            String root = context.substring(0, index == -1 ? context.length() : index);
            D4ScienceIAMClient iamClient = D4ScienceIAMClient.newInstance((String)root);
            D4ScienceIAMClientAuthn d4ScienceIAMClientAuthn = null;
            switch (type) {
                case CLIENT_ID: {
                    String clientId = properties.getProperty(CLIENT_ID_PROPERTY_KEY);
                    String clientSecret = properties.getProperty(root);
                    d4ScienceIAMClientAuthn = iamClient.authenticate(clientId, clientSecret, context);
                    break;
                }
                default: {
                    String username = properties.getProperty(USERNAME_PROPERTY_KEY);
                    String password = properties.getProperty(PASSWORD_PROPERTY_KEY);
                    d4ScienceIAMClientAuthn = iamClient.authenticateUser(username, password, context);
                }
            }
            accessToken = d4ScienceIAMClientAuthn.getAccessTokenString();
            logger.trace("Generated Access Token is {}", (Object)accessToken);
            return accessToken;
        }
        catch (Exception e) {
            logger.error("Unable to set credentials for context {}", (Object)context, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static Secret getSecret(String context) throws RuntimeException {
        String accessToken = ContextTest.getJWTAccessToken(context);
        AccessTokenSecret secret = new AccessTokenSecret(accessToken, context);
        return secret;
    }

    public static void setToken(String token) throws RuntimeException {
        Secret secret = ContextTest.getSecret(token);
        ContextTest.set(secret);
    }

    public static String getUser() {
        String user = "UNKNOWN";
        try {
            user = SecretManagerProvider.get().getOwner().getId();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user. {} will be used", (Object)user);
        }
        return user;
    }

    @BeforeClass
    public static void beforeClass() throws RuntimeException {
        ContextTest.setContextByName(DEFAULT_TEST_CONTEXT);
    }

    @AfterClass
    public static void afterClass() throws RuntimeException {
        SecretManagerProvider.reset();
    }

    static {
        GCUBE = "/gcube";
        DEVSEC = GCUBE + "/devsec";
        DEVVRE = DEVSEC + "/devVRE";
        PARENT_DEFAULT_TEST_CONTEXT = GCUBE;
        DEFAULT_TEST_CONTEXT = DEVVRE;
        ALTERNATIVE_TEST_CONTEXT = DEVSEC;
        properties = new Properties();
        InputStream input = ContextTest.class.getClassLoader().getResourceAsStream(CONFIG_INI_FILENAME);
        try {
            properties.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum Type {
        USER,
        CLIENT_ID;

    }
}

