/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduledtask;

import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.plugin.Ref;
import org.gcube.vremanagement.executor.plugin.RunOn;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ScheduledTask
extends org.gcube.vremanagement.executor.plugin.ScheduledTask {
    protected String context;
    protected String ownerId;
    public static final String LOCALHOST = "localhost";

    protected ScheduledTask() {
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter) throws Exception {
        this(uuid, launchParameter, ScheduledTask.generateRunOn());
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter, RunOn runOn) throws Exception {
        this.uuid = uuid;
        this.launchParameter = launchParameter;
        Secret secret = SecretManagerProvider.get();
        this.context = secret.getContext();
        this.ownerId = secret.getOwner().getId();
        this.runOn = runOn;
    }

    public String getContext() {
        return this.context;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public static RunOn generateRunOn() {
        ApplicationContext applicationContext = ContextProvider.get();
        ApplicationConfiguration applicationConfiguration = applicationContext.configuration();
        ContainerContext container = applicationContext.container();
        ContainerConfiguration containerConfiguration = container.configuration();
        Ref hostingNodeRef = null;
        try {
            hostingNodeRef = new Ref(container.id(), containerConfiguration.hostname() + ":" + containerConfiguration.port());
        }
        catch (Exception e) {
            hostingNodeRef = new Ref("localhost", "localhost");
        }
        Ref eServiceRef = null;
        String baseAddress = null;
        try {
            if (applicationConfiguration.proxable() && containerConfiguration.proxy() != null) {
                ProxyAddress proxy = containerConfiguration.proxy();
                String protocol = proxy.getProtocol();
                String port = proxy.getPort() != null ? ":" + proxy.getPort() : "";
                baseAddress = String.format("%s://%s%s%s", protocol, proxy.getHostname(), port, applicationContext.application().getContextPath());
            } else {
                String protocol = containerConfiguration.protocol();
                int port = containerConfiguration.port();
                baseAddress = String.format("%s://%s:%d%s", protocol, containerConfiguration.hostname(), port, applicationContext.application().getContextPath());
            }
            eServiceRef = new Ref(applicationContext.id(), baseAddress);
        }
        catch (Exception e) {
            eServiceRef = new Ref("localhost", "localhost");
        }
        RunOn runOn = new RunOn(hostingNodeRef, eServiceRef);
        return runOn;
    }

    public String toString() {
        try {
            return ExtendedSEMapper.getInstance().marshal((Object)this);
        }
        catch (Exception e) {
            return "ScheduledTask [context=" + this.context + ", ownerId=" + this.ownerId + ", uuid=" + String.valueOf(this.uuid) + ", launchParameter=" + String.valueOf(this.launchParameter) + ", runOn=" + String.valueOf(this.runOn) + "]";
        }
    }
}

