package org.gcube.common.calls.jaxrs;

import javax.xml.namespace.QName;

import org.gcube.common.calls.Call;
import org.gcube.common.calls.jaxrs.GcubeServiceBuilderDSL.NameClause;

/**
 * Represents a gCube JAX-RS service with its metadata and call configuration.
 * 
 * @author Fabio Simeoni
 */
public class GcubeService {

	private final QName name;
	private String path;
	private final Call call = new Call();
	
	/**
	 * Starts the bulding process for a {@link GcubeService}.
	 * @return the service
	 */
	public static NameClause service() {
		return new GcubeServiceBuilder();
	}
	
	/**
	 * Creates a new gCube service instance.
	 * 
	 * @param name the service QName
	 * @param path the service path
	 */
	public GcubeService(QName name, String path) {
		this.name=name;
		this.path = path;
	}

	/**
	 * Returns the service path.
	 * 
	 * @return the service path
	 */
	public String path() {
		return path;
	}

	/**
	 * Returns the service QName.
	 * 
	 * @return the service QName
	 */
	public QName name() {
		return name;
	}

	/**
	 * Returns the call configuration for this service.
	 * 
	 * @return the call configuration
	 */
	public Call call() {
		return call;
	}
}
