/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.iam;

import java.net.URL;
import java.security.PublicKey;
import java.util.List;
import org.gcube.common.iam.D4ScienceIAMClientAuthn;
import org.gcube.common.iam.D4ScienceIAMClientAuthn4Client;
import org.gcube.common.iam.D4ScienceIAMClientAuthn4User;
import org.gcube.common.iam.D4ScienceIAMClientAuthz;
import org.gcube.common.iam.D4ScienceIAMClientException;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.PublishedRealmRepresentation;
import org.gcube.io.jsonwebtoken.ExpiredJwtException;
import org.gcube.io.jsonwebtoken.JwtException;
import org.gcube.io.jsonwebtoken.security.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D4ScienceIAMClient {
    protected static Logger logger = LoggerFactory.getLogger(D4ScienceIAMClient.class);
    public static boolean USE_DYNAMIC_SCOPES = true;
    private KeycloakClient keycloakClient;
    private URL realmBaseURL;
    private static String GATEWAY_CLIENT_ID = "d4science-internal-gateway";

    public static void setDefaultGatewayClientID(String gatewayClientId) {
        logger.warn("The default GW clientId will be changed to: {}", (Object)gatewayClientId);
        GATEWAY_CLIENT_ID = gatewayClientId;
    }

    public static D4ScienceIAMClient newInstance(String contextInfra) throws D4ScienceIAMClientException {
        KeycloakClient keycloakClient = KeycloakClientFactory.newInstance().useDynamicScopeInsteadOfCustomHeaderForContextRestricion(USE_DYNAMIC_SCOPES);
        logger.debug("Creating new D4ScienceIAMClient with infastructure context: {} ", (Object)contextInfra);
        try {
            return new D4ScienceIAMClient(keycloakClient, keycloakClient.getRealmBaseURL(contextInfra));
        }
        catch (KeycloakClientException e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    public static D4ScienceIAMClient newInstance(String contextInfra, String realm) throws D4ScienceIAMClientException {
        KeycloakClient keycloakClient = KeycloakClientFactory.newInstance().useDynamicScopeInsteadOfCustomHeaderForContextRestricion(USE_DYNAMIC_SCOPES);
        logger.debug("Creating new D4ScienceIAMClient with infastructure context: {}, and realm: {}", (Object)contextInfra, (Object)realm);
        try {
            return new D4ScienceIAMClient(keycloakClient, keycloakClient.getRealmBaseURL(contextInfra, realm));
        }
        catch (KeycloakClientException e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    public static D4ScienceIAMClient newInstance(URL realmBaseURL) {
        logger.debug("Creating new D4ScienceIAMClient with baase URL: {} ", (Object)realmBaseURL);
        return new D4ScienceIAMClient(KeycloakClientFactory.newInstance().useDynamicScopeInsteadOfCustomHeaderForContextRestricion(USE_DYNAMIC_SCOPES), realmBaseURL);
    }

    private D4ScienceIAMClient(KeycloakClient keycloakClient, URL realmBaseURL) {
        this.keycloakClient = keycloakClient;
        this.realmBaseURL = realmBaseURL;
    }

    protected KeycloakClient getKeycloakClient() {
        return this.keycloakClient;
    }

    public URL getRealmBaseURL() {
        return this.realmBaseURL;
    }

    public D4ScienceIAMClientAuthn authenticate(String clientId, String clientSecret) throws D4ScienceIAMClientException {
        return this.authenticate(clientId, clientSecret, null);
    }

    public D4ScienceIAMClientAuthn authenticate(String clientId, String clientSecret, String context) throws D4ScienceIAMClientException {
        return new D4ScienceIAMClientAuthn4Client(this, clientId, clientSecret, context);
    }

    public D4ScienceIAMClientAuthn authenticateUser(String username, String password) throws D4ScienceIAMClientException {
        return this.authenticateUser(GATEWAY_CLIENT_ID, null, username, password);
    }

    public D4ScienceIAMClientAuthn authenticateUser(String username, String password, String context) throws D4ScienceIAMClientException {
        return this.authenticateUser(GATEWAY_CLIENT_ID, null, username, password, context);
    }

    public D4ScienceIAMClientAuthn authenticateUser(String clientId, String clientSecret, String username, String password) throws D4ScienceIAMClientException {
        return this.authenticateUser(clientId, clientSecret, username, password, null);
    }

    public D4ScienceIAMClientAuthn authenticateUser(String clientId, String clientSecret, String username, String password, String context) throws D4ScienceIAMClientException {
        return new D4ScienceIAMClientAuthn4User(this, clientId, clientSecret, username, password, context);
    }

    public D4ScienceIAMClientAuthz authorize(String clientId, String clientSecret, String context) throws D4ScienceIAMClientException {
        return this.authorize(clientId, clientSecret, context, null);
    }

    public D4ScienceIAMClientAuthz authorize(String clientId, String clientSecret, String context, List<String> permissions) throws D4ScienceIAMClientException {
        return new D4ScienceIAMClientAuthz(this, clientId, clientSecret, context, permissions);
    }

    public void verifyToken(String token) throws SignatureException, ExpiredJwtException, JwtException, Exception {
        this.verifyToken(token, true);
    }

    public void verifyToken(String token, boolean checkExpiration) throws SignatureException, ExpiredJwtException, JwtException, Exception {
        PublishedRealmRepresentation realmInfo = this.keycloakClient.getRealmInfo(this.realmBaseURL);
        ModelUtils.isValid((String)token, (PublicKey)realmInfo.getPublicKey(), (boolean)checkExpiration);
    }
}

