/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.proxies.DefaultManagerClient;
import org.gcube.common.storagehub.client.proxies.UserManagerClient;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;

public class DefaultUserManager
extends DefaultManagerClient
implements UserManagerClient {
    public DefaultUserManager(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        super(delegate);
    }

    @Override
    public void createUser(final String userId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                MultivaluedHashMap formData = new MultivaluedHashMap();
                formData.add((Object)"user", (Object)userId);
                formData.add((Object)"password", (Object)(userId + "pwd"));
                GXInboundResponse response = myManager.post(Entity.entity((Object)formData, (String)"application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError("error is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void removeUser(final String userId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                try {
                    GXInboundResponse response = myManager.path(userId).delete();
                    if (response.isErrorResponse()) {
                        if (response.hasException()) {
                            throw response.getException();
                        }
                        if (response.getHTTPCode() == 403) {
                            throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                        }
                        throw new BackendGenericError();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<String> getUsers() throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest, List<String>>(this){

            public List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return (List)response.getSource().readEntity(List.class);
            }
        };
        try {
            List users = (List)this.delegate.make((Call)call);
            return users;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public boolean exists(final String user) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Boolean> call = new Call<GXWebTargetAdapterRequest, Boolean>(){

            public Boolean call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path(user);
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        if (response.getException().getClass().equals(IdNotFoundException.class)) {
                            return false;
                        }
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return true;
            }
        };
        try {
            return (Boolean)this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }
}

