/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningCluster
implements Serializable {
    private static final String GCubePortalConstants_INFRASTRUCTURE_NAME = "infrastructure";
    private static final String PortalContext_CONFIGURATION_FOLDER = "conf";
    private static final String PortalContext_INFRA_PROPERTY_FILENAME = "infrastructure.properties";
    private static final Logger _log = LoggerFactory.getLogger(RunningCluster.class);
    private static final String HOST_PROPERTY = "host";
    private static final String HOST_PORT_PROPERTY = "port";
    private static final String DATACENTER_NAME_PROPERTY = "datacenter";
    private static final String KEY_SPACE_NAME_PROPERTY = "keyspace";
    private static final String RUNTIME_RESOURCE_NAME = "SocialPortalDataStore";
    private static final String PLATFORM_NAME = "Cassandra";
    private static final String DEFAULT_CONFIGURATION = "/org/gcube/portal/databook/server/resources/databook.properties";
    private static RunningCluster singleton;
    private String host = "10.1.28.55:9042, 10.1.30.142:9042, 10.1.28.100:9042";
    private String datacenterName = "1";
    private String keyspaceName = "dev_mig_new_schema_test";

    public static synchronized RunningCluster getInstance(String infrastructureName) {
        if (singleton == null) {
            singleton = new RunningCluster(infrastructureName);
        }
        return singleton;
    }

    private RunningCluster(String infrastructureName) {
    }

    private String readInfrastructureName() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(RunningCluster.getCatalinaHome());
            sb.append(File.separator).append(PortalContext_CONFIGURATION_FOLDER).append(File.separator).append(PortalContext_INFRA_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            return props.getProperty(GCubePortalConstants_INFRASTRUCTURE_NAME);
        }
        catch (IOException e) {
            _log.error("infrastructure.properties file not found under $CATALINA_HOME/conf/ dir, setting default infrastructure Name gcube");
            return "gcube";
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String toString() {
        return "RunningCluster [host=" + this.host + ", datacenterName=" + this.datacenterName + ", keyspaceName=" + this.keyspaceName + "]";
    }

    private static String getCatalinaHome() {
        return System.getenv("CATALINA_HOME").endsWith("/") ? System.getenv("CATALINA_HOME") : System.getenv("CATALINA_HOME") + "/";
    }

    public void setDatacenterName(String datacenterName) {
        this.datacenterName = datacenterName;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public List<InetSocketAddress> getHosts() {
        String[] ips;
        ArrayList<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
        for (String ip : ips = this.host.split(", ")) {
            String[] ip_port = ip.split(":");
            hosts.add(new InetSocketAddress(ip_port[0], Integer.parseInt(ip_port[1])));
        }
        return hosts;
    }
}

