package org.gcube.social_networking.social_networking_client_library.filter;

import java.io.IOException;

import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;

/**
 * Authorization filter for the jersey client.
 */
public class AuthorizationFilter implements ClientRequestFilter {
	private final static String AUTH_TOKEN_PARAMETER = "Authorization";
	private final static String LEGACY_AUTH_TOKEN_PARAMETER = "gcube-token";
	private static Logger logger = LoggerFactory.getLogger(AuthorizationFilter.class);

	@Override
	public void filter(ClientRequestContext original) throws IOException {
		logger.debug("Adding token to the request " + original.getUri());

		Secret secret = SecretManagerProvider.get();
		secret.getHTTPAuthorizationHeaders()
				.forEach((key, value) -> original.getHeaders().add(key, value));

	}
}
