/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.shared;

import java.io.Serializable;
import java.util.Date;

public class Comment
implements Serializable,
Comparable<Comment> {
    private String key;
    private String userid;
    private Date time;
    private String feedid;
    private String text;
    private String fullName;
    private String thumbnailURL;
    private boolean isEdit;
    private Date lastEditTime;

    public Comment() {
    }

    public Comment(String key, String userid, Date time, String feedid, String text, String fullName, String thumbnailURL) {
        this.key = key;
        this.userid = userid;
        this.time = time;
        this.feedid = feedid;
        this.text = text;
        this.fullName = fullName;
        this.thumbnailURL = thumbnailURL;
        this.isEdit = false;
        this.lastEditTime = null;
    }

    public Comment(String key, String userid, Date time, String feedid, String text, String fullName, String thumbnailURL, boolean isEdit, Date editDate) {
        this.key = key;
        this.userid = userid;
        this.time = time;
        this.feedid = feedid;
        this.text = text;
        this.fullName = fullName;
        this.thumbnailURL = thumbnailURL;
        this.isEdit = isEdit;
        this.lastEditTime = editDate;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getFeedid() {
        return this.feedid;
    }

    public void setFeedid(String feedid) {
        this.feedid = feedid;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public void setThumbnailURL(String thumbnailURL) {
        this.thumbnailURL = thumbnailURL;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public Date getLastEditTime() {
        return this.lastEditTime;
    }

    public void setLastEditTime(Date lastEditTime) {
        this.lastEditTime = lastEditTime;
    }

    @Override
    public int compareTo(Comment toCompare) {
        if (this.time.after(toCompare.getTime())) {
            return 1;
        }
        if (this.time.before(toCompare.getTime())) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "Comment [key=" + this.key + ", userid=" + this.userid + ", time=" + String.valueOf(this.time) + ", feedid=" + this.feedid + ", text=" + this.text + ", fullName=" + this.fullName + ", thumbnailURL=" + this.thumbnailURL + ", isEdit=" + this.isEdit + ", lastEditTime=" + String.valueOf(this.lastEditTime) + "]";
    }
}

