/*
 * Decompiled with CFR 0.152.
 */
package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"product.navigation.control.menu.category.key=user", "product.navigation.control.menu.category.order:Integer=10"}, service={ProductNavigationControlMenuEntry.class})
public class CustomGoToProductNavigationControlMenuEntry
implements ProductNavigationControlMenuEntry {
    public String getLabel(Locale locale) {
        return "Sites";
    }

    public String getMarkupView(HttpServletRequest request) {
        return "";
    }

    public String getURL(HttpServletRequest request) {
        return "javascript:void(0);";
    }

    public String getLinkCssClass(HttpServletRequest request) {
        return "control-menu-nav-link";
    }

    public boolean includeBody(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("sites-links.html");){
            if (is != null) {
                String html = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                List siteGroups = user.getMySiteGroups();
                String sitesList = siteGroups.stream().map(group -> {
                    try {
                        String siteName = HtmlUtil.escape((String)group.getDescriptiveName(themeDisplay.getLocale()));
                        String siteUrl = themeDisplay.getPortalURL() + group.getPathFriendlyURL(false, themeDisplay) + group.getFriendlyURL();
                        return "<li><a href=\"" + siteUrl + "\">" + siteName + "</a></li>";
                    }
                    catch (PortalException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.joining());
                if (sitesList.isEmpty()) {
                    sitesList = "<li><span>No sites available</span></li>";
                }
                html = html.replace("{{sitesList}}", sitesList);
                response.getWriter().println(html);
            }
        }
        catch (PortalException e) {
            throw new IOException(e);
        }
        return true;
    }

    public boolean includeIcon(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    public boolean isPanelStateOpen(HttpServletRequest request, String key) {
        return false;
    }

    public boolean isShow(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.isSignedIn();
    }

    public boolean isUseDialog() {
        return false;
    }

    public void setPanelState(HttpServletRequest request, String key, String panelState) {
    }

    public Map<String, Object> getData(HttpServletRequest request) {
        return Map.of("qa-id", "custom_sites_links");
    }

    public String getIcon(HttpServletRequest request) {
        return "globe";
    }

    public String getIconCssClass(HttpServletRequest request) {
        return "";
    }

    public String getKey() {
        return "custom-sites-links";
    }
}

