package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.constants.ProductNavigationControlMenuCategoryKeys;
import org.osgi.service.component.annotations.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;

/**
 * @author netfarm-m2
 */
@Component(
        immediate = true,
        property = {
                "product.navigation.control.menu.category.key=" + ProductNavigationControlMenuCategoryKeys.TOOLS,
                "product.navigation.control.menu.category.order:Integer=3"
        },
        service = ProductNavigationControlMenuEntry.class
)
public class CustomSearchProductNavigationControlMenuEntry implements ProductNavigationControlMenuEntry {

    @Override
    public String getLabel(Locale locale) {
        return "Search";
    }

    @Override
    public String getMarkupView(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getURL(HttpServletRequest httpServletRequest) {
        return "javascript:;";
    }

    @Override
    public String getLinkCssClass(HttpServletRequest httpServletRequest) {
        return "control-menu-nav-link";
    }

    @Override
    public boolean includeBody(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String html;
        try (InputStream is = getClass().getClassLoader().getResourceAsStream("custom-search.html")) {
            html = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        }
        response.getWriter().println(html);
        return true;
    }

    @Override
    public boolean includeIcon(HttpServletRequest request, HttpServletResponse response) {
        return false; // disegno io l’icona nel mio HTML
    }

    @Override
    public boolean isPanelStateOpen(HttpServletRequest httpServletRequest, String key) {
        return false;
    }

    @Override
    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        return true;
    }

    @Override
    public boolean isUseDialog() {
        return false;
    }

    @Override
    public void setPanelState(HttpServletRequest httpServletRequest, String key, String panelState) {}

    @Override
    public Map<String, Object> getData(HttpServletRequest request) {
        return Map.of("qa-id", "custom_search");
    }

    @Override
    public String getIcon(HttpServletRequest request) {
        return "search";
    }

    @Override
    public String getIconCssClass(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getKey() {
        return "custom-search";
    }
}
