/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.group;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import smallgears.api.Apikit;
import smallgears.api.traits.Streamable;

public class Group<E, SELF extends Group<E, SELF>>
implements Streamable<E> {
    private final Map<String, E> elements = Collections.synchronizedMap(new HashMap());
    @NonNull
    private final Function<E, String> name;

    @Override
    public Iterator<E> iterator() {
        return this.elements.values().iterator();
    }

    @SafeVarargs
    public final SELF add(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements is null");
        }
        return this.add(Arrays.asList(elements));
    }

    public SELF add(@NonNull SELF other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        return this.add(((Group)other).elements());
    }

    public SELF add(@NonNull Iterable<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements is null");
        }
        for (E e : elements) {
            this.elements.put(this.name.apply(e), e);
        }
        return this.self();
    }

    @SafeVarargs
    public final SELF remove(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements is null");
        }
        return this.remove(Arrays.asList(elements));
    }

    public SELF remove(@NonNull SELF other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        return this.remove(((Group)other).elements());
    }

    public SELF remove(@NonNull Iterable<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements is null");
        }
        for (E e : elements) {
            this.elements.remove(this.name.apply(e));
        }
        return this.self();
    }

    @SafeVarargs
    public final boolean has(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return this.has((Iterable<String>)Arrays.asList(names));
    }

    @SafeVarargs
    public final boolean has(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements is null");
        }
        return this.has(Arrays.asList(elements));
    }

    public boolean has(@NonNull SELF other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        return this.has((Iterable<String>)((Group)other).names());
    }

    public boolean has(@NonNull Iterable<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return Apikit.streamof(names).allMatch(this.elements::containsKey);
    }

    public boolean has(@NonNull Collection<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("elements is null");
        }
        return Apikit.streamof(elements).allMatch(this.elements::containsValue);
    }

    public Optional<E> get(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return Optional.ofNullable(this.elements.get(name));
    }

    public E getOr(@NonNull String name, E fallback) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Optional<E> e = this.get(name);
        return e.isPresent() ? e.get() : fallback;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public Set<E> elements() {
        return new HashSet<E>(this.elements.values());
    }

    public Set<String> names() {
        return new HashSet<String>(this.elements.keySet());
    }

    public String toString() {
        Function<Map.Entry, String> tostring = $ -> String.format("%s=%s", $.getKey(), $.getValue());
        return String.format("[%s]", this.elements.entrySet().stream().map(tostring).collect(Collectors.joining(",")));
    }

    private SELF self() {
        Group self = this;
        return (SELF)self;
    }

    @ConstructorProperties(value={"name"})
    public Group(@NonNull Function<E, String> name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<E> this$elements = this.elements();
        Set<E> other$elements = other.elements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Function<E, String> this$name = this.name;
        Function<E, String> other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Group;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<E> $elements = this.elements();
        result = result * 59 + ($elements == null ? 0 : ((Object)$elements).hashCode());
        Function<E, String> $name = this.name;
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        return result;
    }
}

