/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import smallgears.api.group.Group;
import smallgears.api.properties.Property;

public class Properties
extends Group<Property, Properties> {
    public static Properties props(Property ... properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return (Properties)new Properties().add(properties);
    }

    public static Property prop(String name, Object value) {
        return Property.prop(name, value);
    }

    private Properties() {
        super(Property::name);
    }

    @Override
    public Properties add(String ... props) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        return this.add((Collection<String>)Arrays.asList(props));
    }

    @Override
    public Properties add(Collection<String> names) {
        return (Properties)this.add(this.coll(names));
    }

    @Override
    public Properties remove(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return this.remove((Collection<String>)Arrays.asList(names));
    }

    @Override
    public Properties remove(@NonNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return (Properties)this.remove(this.coll(names));
    }

    @Override
    public Property getOr(@NonNull String name, String fallback) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Optional e = this.get(name);
        return e.isPresent() ? (Property)e.get() : Properties.prop(name, fallback);
    }

    private Collection<Property> coll(Collection<String> ts) {
        return ts.stream().map(Property::prop).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Properties)) {
            return false;
        }
        Properties other = (Properties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Properties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

