/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.filter.v1_1.OGC;
import org.geotools.xml.Node;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BinarySpatialOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterParsingUtils {
    public static Object Filter_getProperty(Object object, QName name) {
        Filter filter = (Filter)object;
        if (OGC.spatialOps.equals(name) && filter instanceof BinarySpatialOperator) {
            return filter;
        }
        if (OGC.comparisonOps.equals(name)) {
            if (filter instanceof BinaryComparisonOperator && !(filter instanceof BinarySpatialOperator)) {
                return filter;
            }
            if (filter instanceof PropertyIsLike || filter instanceof PropertyIsNull || filter instanceof PropertyIsBetween) {
                return filter;
            }
        }
        if (OGC.logicOps.equals(name) && filter instanceof BinaryLogicOperator) {
            return filter;
        }
        if (filter instanceof Id && (OGC._Id.equals(name) || OGC.FeatureId.equals(name))) {
            Id id = (Id)filter;
            return id.getIdentifiers();
        }
        return null;
    }

    public static List<Filter> BinaryLogicOperator_getChildFilters(Node node, FilterFactory factory) {
        List filters = node.getChildValues(Filter.class);
        if (filters.size() < 2) {
            List ids = node.getChildValues(Identifier.class);
            for (Identifier id : ids) {
                filters.add(factory.id(Collections.singleton(id)));
            }
        }
        return filters;
    }
}

