/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.kml.KMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.Identifier;
import org.xml.sax.SAXException;

public class KMLParser
extends AbstractParser {
    public KMLParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    @Override
    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile("kml", "tmp");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            GTVectorDataBinding data = this.parseXML(tempFile);
            return data;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    private GTVectorDataBinding parseXML(File file) {
        KMLConfiguration configuration = new KMLConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
        try {
            Object parsedData = parser.parse((InputStream)new FileInputStream(file));
            if (parsedData instanceof FeatureCollection) {
                fc = (FeatureCollection)parsedData;
            } else if (parsedData instanceof HashMap) {
                ArrayList featureList = (ArrayList)((HashMap)parsedData).get("featureMember");
                if (featureList != null) {
                    for (SimpleFeature feature : featureList) {
                        fc.add((Feature)feature);
                    }
                } else {
                    fc = (FeatureCollection)((HashMap)parsedData).get("FeatureCollection");
                }
            } else if (parsedData instanceof SimpleFeature) {
                Collection values = ((SimpleFeature)parsedData).getValue();
                for (Property value : values) {
                    Object tempValue = value.getValue();
                    if (!value.getType().getBinding().isAssignableFrom(FeatureCollection.class) || !(tempValue instanceof ArrayList)) continue;
                    ArrayList list = (ArrayList)tempValue;
                    for (Object listValue : list) {
                        if (!(listValue instanceof SimpleFeature)) continue;
                        fc.add((Feature)listValue);
                    }
                }
            }
            for (SimpleFeature feature : fc) {
                if (feature.getDefaultGeometry() != null) continue;
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    try {
                        Geometry g = (Geometry)property.getValue();
                        if (g == null) continue;
                        GeometryAttribute oldGeometryDescriptor = feature.getDefaultGeometryProperty();
                        GeometryTypeImpl type = new GeometryTypeImpl(property.getName(), oldGeometryDescriptor.getType().getBinding(), oldGeometryDescriptor.getType().getCoordinateReferenceSystem(), oldGeometryDescriptor.getType().isIdentified(), oldGeometryDescriptor.getType().isAbstract(), oldGeometryDescriptor.getType().getRestrictions(), oldGeometryDescriptor.getType().getSuper(), oldGeometryDescriptor.getType().getDescription());
                        GeometryDescriptorImpl newGeometryDescriptor = new GeometryDescriptorImpl((GeometryType)type, property.getName(), 0, 1, true, null);
                        GmlObjectIdImpl identifier = new GmlObjectIdImpl(feature.getID());
                        GeometryAttributeImpl geo = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)newGeometryDescriptor, (Identifier)identifier);
                        feature.setDefaultGeometryProperty((GeometryAttribute)geo);
                        feature.setDefaultGeometry((Object)g);
                    }
                    catch (ClassCastException e) {}
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)fc);
        return data;
    }
}

