/*
 * Decompiled with CFR 0.152.
 */
package org.grade.service.aux;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.hp.hpl.jena.query.QueryParseException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.jena.atlas.web.HttpException;
import org.grade.service.aux.GradeError;

public class ErrorBarrier {
    private static Response response(Response.Status status, Exception e) {
        return Response.status((Response.Status)status).entity((Object)new GradeError(status.getStatusCode(), e)).type("application/json").build();
    }

    @Provider
    public static class ISEMapper
    implements ExceptionMapper<IllegalStateException> {
        public Response toResponse(IllegalStateException e) {
            return ErrorBarrier.response(Response.Status.CONFLICT, e);
        }
    }

    @Provider
    public static class QueryParseExceptionMapper
    implements ExceptionMapper<QueryParseException> {
        public Response toResponse(QueryParseException e) {
            return ErrorBarrier.response(Response.Status.BAD_REQUEST, (Exception)e);
        }
    }

    @Provider
    public static class IllegalArgumentExceptionMapper
    implements ExceptionMapper<IllegalArgumentException> {
        public Response toResponse(IllegalArgumentException e) {
            return ErrorBarrier.response(Response.Status.BAD_REQUEST, e);
        }
    }

    @Provider
    public static class JenaHTTPErrorMapper
    implements ExceptionMapper<HttpException> {
        public Response toResponse(HttpException e) {
            if (e.getResponseCode() != -1) {
                return ErrorBarrier.response(Response.Status.fromStatusCode((int)e.getResponseCode()), (Exception)e);
            }
            return ErrorBarrier.response(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e);
        }
    }

    @Provider
    public static class GenericExceptionMapper
    implements ExceptionMapper<JsonMappingException> {
        public Response toResponse(JsonMappingException e) {
            return ErrorBarrier.response(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e);
        }
    }
}

