/*
 * Decompiled with CFR 0.152.
 */
package org.grade.service.resources;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.Source;
import lombok.NonNull;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.Configuration;
import org.grade.io.DropinService;
import org.grade.io.SourceInfo;
import org.grade.io.aux.Csv;
import org.grade.repo.GenericRepository;
import org.grade.service.resources.RepositoryResource;

@ApplicationScoped
@Path(value="/stage")
public class StagingResource
extends RepositoryResource<GenericRepository> {
    @Inject
    private DropinService dservice;

    StagingResource() {
    }

    @Inject
    public StagingResource(@Qualifiers.Staging GenericRepository repo, Configuration cfg, Event<Configuration> events) {
        super(repo, cfg, cfg.staging(), events);
    }

    @GET
    @Path(value="/datasets")
    @Produces(value={"application/json"})
    public List<Map<String, String>> sets(@Context UriInfo info) {
        return ((GenericRepository)this.repo).get("all_datasets", this.paramsfrom(info)).stream().map(res -> res.map()).collect(Collectors.toList());
    }

    @POST
    @Path(value="/endpoint/{key}/dropin/csv/{name}")
    @Consumes(value={"multipart/form-data"})
    public void dropinCsv(@PathParam(value="key") @NonNull String key, @PathParam(value="name") @NonNull String name, @FormDataParam(value="content") @NonNull FormDataBodyPart content, @FormDataParam(value="info") @NonNull Csv csv) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content is null");
        }
        if (csv == null) {
            throw new IllegalArgumentException("csv is null");
        }
        this.dservice.dropin(SourceInfo.info((String)key, (String)name), (Object)csv.asTable((InputStream)content.getEntityAs(InputStream.class)));
    }

    @POST
    @Path(value="/endpoint/{key}/dropin/xml/{name}")
    @Consumes(value={"application/xml"})
    public void dropinXml(Source source, @PathParam(value="key") @NonNull String key, @PathParam(value="name") @NonNull String name) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.dservice.dropin(SourceInfo.info((String)key, (String)name), (Object)source);
    }

    @POST
    @Path(value="/endpoint/{key}/dropin/json/{name}")
    @Consumes(value={"application/json"})
    public void dropinJson(JsonNode node, @PathParam(value="key") @NonNull String key, @PathParam(value="name") @NonNull String name) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("can only ingest json objects, not this " + node.getNodeType());
        }
        this.dservice.dropin(SourceInfo.info((String)key, (String)name), (Object)node);
    }
}

