/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.taxonomy;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermLinkPK;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@javax.persistence.Entity
@IdClass(value=TaxonomyTermLinkPK.class)
@Table(name="\"TaxonomyTermLink\"")
public class TaxonomyTermLink
implements Entity,
Stampable {
    @Id
    @ManyToOne
    @JoinColumn(name="\"TAXTL_SourceTerm\"", nullable=false)
    private Geocode sourceTerm = null;
    @Id
    @ManyToOne
    @JoinColumn(name="\"TAXTL_DestinationTerm\"", nullable=false)
    private Geocode destinationTerm = null;
    @Column(name="\"TAXTL_Verb\"", nullable=false)
    private int verb = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"TAXTL_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"TAXTL_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"TAXTL_Creator\"", nullable=false)
    private Principal creator;

    public Geocode getDestinationTerm() {
        return this.destinationTerm;
    }

    public void setDestinationTerm(Geocode destinationTerm) {
        this.destinationTerm = destinationTerm;
    }

    public Geocode getSourceTerm() {
        return this.sourceTerm;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public void setSourceTerm(Geocode sourceTerm) {
        this.sourceTerm = sourceTerm;
    }

    public Verb getVerb() {
        return Verb.fromVerbCode(this.verb);
    }

    public void setVerb(Verb verb) {
        this.verb = verb.verbCode();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String toString() {
        return "TaxonomyTermLink( sourceTerm=" + (this.sourceTerm != null ? this.sourceTerm.getId() : null) + " destinationTerm=" + (this.destinationTerm != null ? this.destinationTerm.getId() : null) + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null);
    }

    public static enum Verb {
        Equivalent(0),
        Contains(1),
        LayerFor(2),
        LandUseFor(3),
        POIFor(4),
        SiteFor(5),
        AttrFor(6);

        private final int verbCode;
        private static final Map<Integer, Verb> lookup;

        private Verb(int verbCode) {
            this.verbCode = verbCode;
        }

        public int verbCode() {
            return this.verbCode;
        }

        public static Verb fromVerbCode(int verbCode) {
            return lookup.get(verbCode);
        }

        static {
            lookup = new HashMap<Integer, Verb>();
            for (Verb s : EnumSet.allOf(Verb.class)) {
                lookup.put(s.verbCode(), s);
            }
        }
    }
}

